% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_7_textZeroShot.R
\name{textZeroShot}
\alias{textZeroShot}
\title{Zero Shot Classification (Experimental)}
\usage{
textZeroShot(
  sequences,
  candidate_labels,
  hypothesis_template = "This example is {}.",
  multi_label = FALSE,
  model = "",
  device = "cpu",
  tokenizer_parallelism = FALSE,
  logging_level = "error",
  return_incorrect_results = FALSE,
  set_seed = 202208L
)
}
\arguments{
\item{sequences}{(string)  The sequence(s) to classify (not that they will be truncated
if the model input is too large).}

\item{candidate_labels}{(string) The set of class labels that is possible in the to
classification of each sequence. It may be a single label, a string of comma-separated
labels, or a list of labels.}

\item{hypothesis_template}{(string; optional)
The template that is used for turning each of the label into an NLI-style hypothesis.
This template must include a "{}" or similar syntax so that the candidate label can be
inserted into the template. For example, the default template is
"This example is {}." With the candidate label "sports",
this would be fed into the model like "<cls> sequence to classify <sep> This example is sports . <sep>".
The default template works well in many cases, but it may be worthwhile to experiment with different templates
depending on the task setting (see https://huggingface.co/docs/transformers/).}

\item{multi_label}{(boolean; optional) It indicates whether multiple candidate labels can be true. If FALSE, the scores
are normalized such that the sum of the label likelihoods for each sequence is 1.
If TRUE, the labels are considered independent and probabilities are normalized for each candidate by doing a softmax
of the entailment score vs. the contradiction score.}

\item{model}{(string)  Specify a pre-trained language model that have been fine-tuned on a translation task.}

\item{device}{(string)  Name of device to use: 'cpu', 'gpu', or 'gpu:k' where k is a specific device number}

\item{tokenizer_parallelism}{(boolean)  If TRUE this will turn on tokenizer parallelism.}

\item{logging_level}{(string)  Set the logging level.
Options (ordered from less logging to more logging): critical, error, warning, info, debug}

\item{return_incorrect_results}{(boolean)  Stop returning some incorrectly formatted/structured results.
This setting does CANOT evaluate the actual results (whether or not they make sense, exist, etc.).
All it does is to ensure the returned results are formatted correctly (e.g., does the question-answering
dictionary contain the key "answer", is sentiments from textClassify containing the labels "positive" and "negative").}

\item{set_seed}{(Integer) Set seed.}
}
\value{
A tibble with the result with the following keys:
sequence (string) The imputed sequence.
labels (string) The labels sorted in the order of likelihood.
scores (numeric) The probabilities for each of the labels.
}
\description{
Zero Shot Classification (Experimental)
}
\examples{
\donttest{
# ZeroShot_example <- text::textZeroShot(sequences = c("I play football",
# "The forest is wonderful"),
# candidate_labels = c("sport", "nature", "research"),
# model = "facebook/bart-large-mnli")
}
}
\seealso{
see \code{\link{textClassify}}, \code{\link{textGeneration}}, \code{\link{textNER}},
 \code{\link{textSum}}, \code{\link{textQA}}, \code{\link{textTranslate}}
}
