% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_1_textSimilarity.R
\name{textDistanceMatrix}
\alias{textDistanceMatrix}
\title{Compute semantic distance scores between all combinations in a word embedding}
\usage{
textDistanceMatrix(x, method = "euclidean", center = FALSE, scale = FALSE)
}
\arguments{
\item{x}{Word embeddings (from textEmbed).}

\item{method}{(character) Character string describing type of measure to be computed; default is
"euclidean" (see also measures from stats:dist() including "maximum", "manhattan", "canberra",
"binary" and "minkowski". It is also possible to use "cosine", which computes the cosine distance
(i.e., 1 - cosine(x, y)).}

\item{center}{(boolean; from base::scale) If center is TRUE then centering is done by subtracting
the embedding mean
(omitting NAs) of x from each of its dimension, and if center is FALSE, no centering is done.}

\item{scale}{(boolean; from base::scale) If scale is TRUE then scaling is done by dividing the
(centered) embedding dimensions by the standard deviation of the embedding if center is TRUE,
 and the root mean square otherwise.}
}
\value{
A matrix of semantic distance scores
}
\description{
Compute semantic distance scores between all combinations in a word embedding
}
\examples{
distance_scores <- textDistanceMatrix(word_embeddings_4$texts$harmonytext[1:3, ])
round(distance_scores, 3)
}
\seealso{
see \code{\link{textDistanceNorm}}
}
