% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.evm.R
\name{ggplot.evmOpt}
\alias{ggplot.evmOpt}
\alias{ggplot.ppevm}
\alias{ggplot.qqevm}
\alias{ggplot.hist.evmOpt}
\alias{ggplot.evmOpt,}
\alias{ggplotrl}
\title{Diagnostic plots for an evm object}
\usage{
\method{ggplot}{evmOpt}(data, mapping, which = 1:4, main = rep(NULL,
  4), xlab = rep(NULL, 4), nsim = 1000, alpha = 0.05,
  jitter.width = 0, ptcol = "blue", span = 2/3, col = "light blue",
  fill = "orange", plot. = TRUE, ncol = 2, nrow = 2, ...,
  environment)
}
\arguments{
\item{data}{An object of class \code{evm}.}

\item{mapping, environment}{ignored}

\item{which}{Which plots to produce. Defaults to \code{which=1:4}.}

\item{main}{Main titles. Should have length 4.}

\item{xlab}{Labels for x-axes.}

\item{nsim}{Number of simulated datasets to create to form
tolerence regions.}

\item{alpha}{Used to compute coverage of pointwise confidence
intervals.}

\item{jitter.width}{Used to control the amount of horizontal
jittering of points in the plots of the residuals versus
covariates (when covariates are in the model).  Defaults to
\code{jitter.width=0}.}

\item{ptcol}{Colour for points. Defaults to \code{ptcol="blue"}.}

\item{span}{Passed to the loess smoother and defaults to
\code{span=2/3}. Sometimes this choice is poor: if the loess
smoother looks wrong, try \code{span=1}.}

\item{col}{Colour for lines. Defaults to \code{col="light blue"}.}

\item{fill}{Colour for confidence regions. Defaults to
\code{fill="orange"}}

\item{plot.}{Whether or not to display the output. Defaults to
\code{plot.=TRUE}.  If the display doesn't have the desired row
and column layout, the user should specify \code{plot.=FALSE},
asign the output to an object, and use \code{grid.arrange} to
display it.}

\item{ncol}{The number of columns wanted in the resulting
plot. Defaults to \code{ncol=2}. This argument is passed into
\code{grid.arrange}.}

\item{nrow}{The number of rows wanted in the resulting
plot. Defaults to \code{nrow=2}. This argument is passed into
\code{grid.arrange}.}

\item{...}{Other arguments passed through to underlying plot
functions.}
}
\description{
Create and display diagnostic plots for an evm object. See \code{\link{plot.evmOpt}}
for further details on what is being plotted.
}
\details{
The function attempts to arrange the plots nicely. If the
    output isn't what was wanted, the function returns the graphs
    to the user as a list so that the user can use
    \code{grid.arrange} directly.  Also, if you have one or more
    covariates in the model and the loess smoother looks wrong, try
    setting \code{span=1}.
}
\seealso{
\code{\link{plot.evmOpt}}
}
\keyword{hplot}
