% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildUsepackage.R
\name{buildUsepackage}
\alias{buildUsepackage}
\title{Build usepackage command for TeX document}
\usage{
buildUsepackage(pkg, options = NULL, uselibrary = NULL, chk.inst = FALSE)
}
\arguments{
\item{pkg}{character, name of TeX package}

\item{options}{character, name(s) of options to use in the package}

\item{uselibrary}{character, part of document preamble to specify a uselibrary call related to package}

\item{chk.inst}{logical, invokes a check to see if pkg is currently installed on system (default FALSE)}
}
\value{
character
}
\description{
input TeX package name and optional package functions to create usepackage call
}
\details{
if options and uselibrary are NULL (default) then only the call for the package is returned.
See the TeX wikibook for more information \url{https://en.wikibooks.org/wiki/LaTeX/Document_Structure#Packages} on 
the usepackage command. If chk.inst finds that the package is not installed on system function returns NULL.
}
\examples{
buildUsepackage(pkg = 'xcolor')
buildUsepackage(pkg = 'xcolor',options = 'usenames')

#build many at once using mapply

geom.opts=c('paperwidth=35cm','paperheight=35cm','left=2.5cm','top=2.5cm')
use.opts="\\\\usetikzlibrary{mindmap,backgrounds}"

unlist(mapply(buildUsepackage,
pkg =        list('times','geometry','tikz'),
options=     list(NULL   ,geom.opts ,NULL),
uselibrary = list(NULL   ,NULL      ,use.opts)
))
}
