% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-silent.R
\name{expect_silent}
\alias{expect_silent}
\title{Expectation: is the code silent?}
\usage{
expect_silent(object)
}
\arguments{
\item{object}{Object to test.

Supports limited unquoting to make it easier to generate readable failures
within a function or for loop. See \link{quasi_label} for more details.}
}
\value{
The first argument, invisibly.
}
\description{
Checks that the code produces no output, messages, or warnings.
}
\examples{
expect_silent("123")

f <- function() {
  message("Hi!")
  warning("Hey!!")
  print("OY!!!")
}
\dontrun{
expect_silent(f())
}
}
\seealso{
Other expectations: \code{\link{comparison-expectations}},
  \code{\link{equality-expectations}},
  \code{\link{expect_error}}, \code{\link{expect_length}},
  \code{\link{expect_match}}, \code{\link{expect_message}},
  \code{\link{expect_named}}, \code{\link{expect_null}},
  \code{\link{expect_output}},
  \code{\link{inheritance-expectations}},
  \code{\link{logical-expectations}}
}
\concept{expectations}
