% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-make.R
\name{expect_make}
\alias{expect_make}
\title{Create an expectation from a check function}
\usage{
expect_make(
  func,
  func_desc = NULL,
  vars = FALSE,
  all = TRUE,
  env = caller_env()
)
}
\arguments{
\item{func}{A function whose first argument takes a vector to check, and
returns a logical vector of the same length with the results.}

\item{func_desc}{A character function description to use in the expectation
failure message.}

\item{vars}{Included for backwards compatibility only.}

\item{all}{Function to use to combine results for each vector.}

\item{env}{The parent environment of the function, defaults to the calling
environment of \code{expect_make()}.}
}
\value{
An \verb{expect_*()} style function.
}
\description{
\code{expect_make()} creates an expectation from a vectorised checking function to
allow simple generation of domain specific data checks.
}
\examples{
# Create a custom check
chk_binary <- function(x) {
  suppressWarnings(as.integer(x) \%in\% 0:1)
}

# Create custom expectation function
expect_binary <- expect_make(chk_binary)

# Validate a data frame
try(expect_binary(vs, data = mtcars))
try(expect_binary(cyl, data = mtcars))

}
