% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymptoticComplexityClassifier.R
\name{asymptoticComplexityClassifier}
\alias{asymptoticComplexityClassifier}
\title{Asymptotic Complexity Classifier function}
\usage{
asymptoticComplexityClassifier(df)
}
\arguments{
\item{df}{A data frame returned by asymptoticComplexityClass.}
}
\value{
A string specifying the resultant complexity class. (Eg: 'Linear', 'Log-linear', 'Quadratic')
}
\description{
Function to classify the complexity trend between the two parameters as provided by asymptoticComplexityClass
}
\details{
For more information regarding its implementation or functionality/usage, please check https://anirban166.github.io//Generalized-complexity/
}
\examples{
# Avoiding for CRAN since computation time might exceed 5 seconds sometimes:
\donttest{
# Running the quick sort algorithm with sampling against a set of increasing input data sizes:
sizes = 10^seq(1, 3, by = 0.5)
df <- asymptoticTimings(sort(sample(1:100, data.sizes, replace = TRUE), method = "quick"), sizes)
# Classifying the complexity trend between the data contained in the columns
# 'Timings' and 'Data sizes' from the data frame obtained above:
resultant.df <- data.frame('output' = df$Timings, 'size' = df$`Data sizes`)
asymptoticComplexityClassifier(resultant.df)
# For quick sort, the log-linear time complexity class is expected.
}
}
