% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_ipp.R
\name{h_g_ipp}
\alias{h_g_ipp}
\title{Helper function to create simple line plot over time}
\usage{
h_g_ipp(
  df,
  xvar,
  yvar,
  xlab,
  ylab,
  id_var,
  title = "Individual Patient Plots",
  subtitle = "",
  caption = NULL,
  add_baseline_hline = FALSE,
  yvar_baseline = "BASE",
  ggtheme = nestcolor::theme_nest(),
  col = NULL
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{xvar}{(\code{string})\cr time point variable to be plotted on x-axis.}

\item{yvar}{(\code{string})\cr continuous analysis variable to be plotted on y-axis.}

\item{xlab}{(\code{string})\cr plot label for x-axis.}

\item{ylab}{(\code{string})\cr plot label for y-axis.}

\item{id_var}{(\code{string})\cr variable used as patient identifier.}

\item{title}{(\code{string})\cr title for plot.}

\item{subtitle}{(\code{string})\cr subtitle for plot.}

\item{caption}{(\code{string})\cr optional caption below the plot.}

\item{add_baseline_hline}{(\code{flag})\cr adds horizontal line at baseline y-value on
plot when \code{TRUE}.}

\item{yvar_baseline}{(\code{string})\cr variable with baseline values only.
Ignored when \code{add_baseline_hline} is \code{FALSE}.}

\item{ggtheme}{(\code{theme})\cr optional graphical theme function as provided
by \code{ggplot2} to control outlook of plot. Use \code{ggplot2::theme()} to tweak the display.}

\item{col}{(\code{character})\cr line colors.}
}
\value{
A \code{ggplot} line plot.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Function that generates a simple line plot displaying parameter trends over time.
}
\examples{
library(dplyr)

# Select a small sample of data to plot.
adlb <- tern_ex_adlb \%>\%
  filter(PARAMCD == "ALT", !(AVISIT \%in\% c("SCREENING", "BASELINE"))) \%>\%
  slice(1:36)

p <- h_g_ipp(
  df = adlb,
  xvar = "AVISIT",
  yvar = "AVAL",
  xlab = "Visit",
  id_var = "USUBJID",
  ylab = "SGOT/ALT (U/L)",
  add_baseline_hline = TRUE
)
p

}
\seealso{
\code{\link[=g_ipp]{g_ipp()}} which uses this function.
}
