% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_forest.R
\name{g_forest}
\alias{g_forest}
\title{Create a forest plot from an \code{rtable}}
\usage{
g_forest(
  tbl,
  col_x = attr(tbl, "col_x"),
  col_ci = attr(tbl, "col_ci"),
  vline = 1,
  forest_header = attr(tbl, "forest_header"),
  xlim = c(0.1, 10),
  logx = TRUE,
  x_at = c(0.1, 1, 10),
  width_row_names = lifecycle::deprecated(),
  width_columns = NULL,
  width_forest = lifecycle::deprecated(),
  lbl_col_padding = 0,
  rel_width_forest = 0.25,
  font_size = 12,
  col_symbol_size = attr(tbl, "col_symbol_size"),
  col = getOption("ggplot2.discrete.colour")[1],
  ggtheme = NULL,
  as_list = FALSE,
  gp = lifecycle::deprecated(),
  draw = lifecycle::deprecated(),
  newpage = lifecycle::deprecated()
)
}
\arguments{
\item{tbl}{(\code{VTableTree})\cr \code{rtables} table with at least one column with a single value and one column with 2
values.}

\item{col_x}{(\code{integer(1)} or \code{NULL})\cr column index with estimator. By default tries to get this from
\code{tbl} attribute \code{col_x}, otherwise needs to be manually specified. If \code{NULL}, points will be excluded
from forest plot.}

\item{col_ci}{(\code{integer(1)} or \code{NULL})\cr column index with confidence intervals. By default tries to get this from
\code{tbl} attribute \code{col_ci}, otherwise needs to be manually specified. If \code{NULL}, lines will be excluded
from forest plot.}

\item{vline}{(\code{numeric(1)} or \code{NULL})\cr x coordinate for vertical line, if \code{NULL} then the line is omitted.}

\item{forest_header}{(\code{character(2)})\cr text displayed to the left and right of \code{vline}, respectively.
If \code{vline = NULL} then \code{forest_header} is not printed. By default tries to get this from \code{tbl} attribute
\code{forest_header}. If \code{NULL}, defaults will be extracted from the table if possible, and set to
\code{"Comparison\\nBetter"} and \code{"Treatment\\nBetter"} if not.}

\item{xlim}{(\code{numeric(2)})\cr limits for x axis.}

\item{logx}{(\code{flag})\cr show the x-values on logarithm scale.}

\item{x_at}{(\code{numeric})\cr x-tick locations, if \code{NULL}, \code{x_at} is set to \code{vline} and both \code{xlim} values.}

\item{width_row_names}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use the \code{lbl_col_padding} argument instead.}

\item{width_columns}{(\code{numeric})\cr a vector of column widths. Each element's position in
\code{colwidths} corresponds to the column of \code{tbl} in the same position. If \code{NULL}, column widths are calculated
according to maximum number of characters per column.}

\item{width_forest}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use the \code{rel_width_forest} argument instead.}

\item{lbl_col_padding}{(\code{numeric})\cr additional padding to use when calculating spacing between
the first (label) column and the second column of \code{tbl}. If \code{colwidths} is specified,
the width of the first column becomes \code{colwidths[1] + lbl_col_padding}. Defaults to 0.}

\item{rel_width_forest}{(\code{proportion})\cr proportion of total width to allocate to the forest plot. Relative
width of table is then \code{1 - rel_width_forest}. If \code{as_list = TRUE}, this parameter is ignored.}

\item{font_size}{(\code{numeric(1)})\cr font size.}

\item{col_symbol_size}{(\code{numeric} or \code{NULL})\cr column index from \code{tbl} containing data to be used
to determine relative size for estimator plot symbol. Typically, the symbol size is proportional
to the sample size used to calculate the estimator. If \code{NULL}, the same symbol size is used for all subgroups.
By default tries to get this from \code{tbl} attribute \code{col_symbol_size}, otherwise needs to be manually specified.}

\item{col}{(\code{character})\cr color(s).}

\item{ggtheme}{(\code{theme})\cr a graphical theme as provided by \code{ggplot2} to control styling of the plot.}

\item{as_list}{(\code{flag})\cr whether the two \code{ggplot} objects should be returned as a list. If \code{TRUE}, a named list
with two elements, \code{table} and \code{plot}, will be returned. If \code{FALSE} (default) the table and forest plot are
printed side-by-side via \code{\link[cowplot:plot_grid]{cowplot::plot_grid()}}.}

\item{gp}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{g_forest} is now generated as a \code{ggplot} object. This argument
is no longer used.}

\item{draw}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{g_forest} is now generated as a \code{ggplot} object. This argument
is no longer used.}

\item{newpage}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{g_forest} is now generated as a \code{ggplot} object. This argument
is no longer used.}
}
\value{
\code{ggplot} forest plot and table.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
Given a \code{\link[rtables:rtable]{rtables::rtable()}} object with at least one column with a single value and one column with 2
values, converts table to a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object and generates an accompanying forest plot. The
table and forest plot are printed side-by-side.
}
\examples{
library(dplyr)
library(forcats)
library(nestcolor)

adrs <- tern_ex_adrs
n_records <- 20
adrs_labels <- formatters::var_labels(adrs, fill = TRUE)
adrs <- adrs \%>\%
  filter(PARAMCD == "BESRSPI") \%>\%
  filter(ARM \%in\% c("A: Drug X", "B: Placebo")) \%>\%
  slice(seq_len(n_records)) \%>\%
  droplevels() \%>\%
  mutate(
    # Reorder levels of factor to make the placebo group the reference arm.
    ARM = fct_relevel(ARM, "B: Placebo"),
    rsp = AVALC == "CR"
  )
formatters::var_labels(adrs) <- c(adrs_labels, "Response")
df <- extract_rsp_subgroups(
  variables = list(rsp = "rsp", arm = "ARM", subgroups = c("SEX", "STRATA2")),
  data = adrs
)
# Full commonly used response table.

tbl <- basic_table() \%>\%
  tabulate_rsp_subgroups(df)
g_forest(tbl)

# Odds ratio only table.

tbl_or <- basic_table() \%>\%
  tabulate_rsp_subgroups(df, vars = c("n_tot", "or", "ci"))
g_forest(
  tbl_or,
  forest_header = c("Comparison\nBetter", "Treatment\nBetter")
)

# Survival forest plot example.
adtte <- tern_ex_adtte
# Save variable labels before data processing steps.
adtte_labels <- formatters::var_labels(adtte, fill = TRUE)
adtte_f <- adtte \%>\%
  filter(
    PARAMCD == "OS",
    ARM \%in\% c("B: Placebo", "A: Drug X"),
    SEX \%in\% c("M", "F")
  ) \%>\%
  mutate(
    # Reorder levels of ARM to display reference arm before treatment arm.
    ARM = droplevels(fct_relevel(ARM, "B: Placebo")),
    SEX = droplevels(SEX),
    AVALU = as.character(AVALU),
    is_event = CNSR == 0
  )
labels <- list(
  "ARM" = adtte_labels["ARM"],
  "SEX" = adtte_labels["SEX"],
  "AVALU" = adtte_labels["AVALU"],
  "is_event" = "Event Flag"
)
formatters::var_labels(adtte_f)[names(labels)] <- as.character(labels)
df <- extract_survival_subgroups(
  variables = list(
    tte = "AVAL",
    is_event = "is_event",
    arm = "ARM", subgroups = c("SEX", "BMRKR2")
  ),
  data = adtte_f
)
table_hr <- basic_table() \%>\%
  tabulate_survival_subgroups(df, time_unit = adtte_f$AVALU[1])
g_forest(table_hr)

# Works with any `rtable`.
tbl <- rtable(
  header = c("E", "CI", "N"),
  rrow("", 1, c(.8, 1.2), 200),
  rrow("", 1.2, c(1.1, 1.4), 50)
)
g_forest(
  tbl = tbl,
  col_x = 1,
  col_ci = 2,
  xlim = c(0.5, 2),
  x_at = c(0.5, 1, 2),
  col_symbol_size = 3
)

tbl <- rtable(
  header = rheader(
    rrow("", rcell("A", colspan = 2)),
    rrow("", "c1", "c2")
  ),
  rrow("row 1", 1, c(.8, 1.2)),
  rrow("row 2", 1.2, c(1.1, 1.4))
)
g_forest(
  tbl = tbl,
  col_x = 1,
  col_ci = 2,
  xlim = c(0.5, 2),
  x_at = c(0.5, 1, 2),
  vline = 1,
  forest_header = c("Hello", "World")
)

}
