% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_stats.R
\name{summary_stats}
\alias{summary_stats}
\alias{summary_formats}
\alias{summary_labels}
\alias{summary_custom}
\title{Summary Statistic Settings Functions}
\usage{
summary_formats(type = "numeric", include_pval = FALSE)

summary_labels(type = "numeric", include_pval = FALSE)

summary_custom(
  type = "numeric",
  include_pval = FALSE,
  stats_custom = NULL,
  formats_custom = NULL,
  labels_custom = NULL,
  indent_mods_custom = NULL
)
}
\arguments{
\item{type}{(\code{character})\cr choice of summary data type. Only \code{counts} and \code{numeric} types are currently supported.}

\item{include_pval}{(\code{logical})\cr whether p-value should be included as a default statistic.}

\item{stats_custom}{(\verb{named vector} of \code{character})\cr vector of statistics to include if not the defaults. This
argument overrides \code{include_pval} and other custom value arguments such that only settings for these statistics
will be returned.}

\item{formats_custom}{(\verb{named vector} of \code{character})\cr vector of custom statistics formats to use in place of the
defaults defined in \code{\link[=summary_formats]{summary_formats()}}. Names should be a subset of the statistics defined in \code{stats_custom} (or
default statistics if this is \code{NULL}).}

\item{labels_custom}{(\verb{named vector} of \code{character})\cr vector of custom statistics labels to use in place of the
defaults defined in \code{\link[=summary_labels]{summary_labels()}}. Names should be a subset of the statistics defined in \code{stats_custom} (or
default statistics if this is \code{NULL}).}

\item{indent_mods_custom}{(\code{integer} or \verb{named vector} of \code{integer})\cr vector of custom indentation modifiers for
statistics to use instead of the default of \code{0L} for all statistics. Names should be a subset of the statistics
defined in \code{stats_custom} (or default statistics if this is \code{NULL}). Alternatively, the same indentation modifier
can be applied to all statistics by setting \code{indent_mods_custom} to a single integer value.}
}
\value{
\itemize{
\item \code{summary_formats} returns a named \code{vector} of default statistic formats for the given data type.
}

\itemize{
\item \code{summary_labels} returns a named \code{vector} of default statistic labels for the given data type.
}

\itemize{
\item \code{summary_custom} returns a \code{list} of 4 named elements: \code{stats}, \code{formats}, \code{labels}, and \code{indent_mods}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Functions to retrieve default settings for summary statistics and customize these settings.
}
\section{Functions}{
\itemize{
\item \code{summary_formats()}: Function to retrieve default formats for summary statistics. Returns format patterns for
descriptive statistics which are understood by \code{rtables}.

\item \code{summary_labels()}: Function to retrieve default labels for summary statistics. Returns labels of descriptive
statistics which are understood by \code{rtables}.

\item \code{summary_custom()}: Function to configure settings for default or custom summary statistics for a given data
type. In addition to selecting a custom subset of statistics, the user can also set custom formats, labels, and
indent modifiers for any of these statistics.

}}
\examples{
summary_formats()
summary_formats(type = "count", include_pval = TRUE)

summary_labels()
summary_labels(type = "count", include_pval = TRUE)

summary_custom()
summary_custom(type = "counts", include_pval = TRUE)
summary_custom(
  include_pval = TRUE, stats_custom = c("n", "mean", "sd", "pval"),
  labels_custom = c(sd = "Std. Dev."), indent_mods_custom = 3L
)

}
