% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_colvars.R
\name{summarize_colvars}
\alias{summarize_colvars}
\title{Summarize Variables in Columns}
\usage{
summarize_colvars(
  lyt,
  ...,
  na_level = NA_character_,
  .stats = c("n", "mean_sd", "median", "range", "count_fraction"),
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{...}{arguments passed to \code{s_summary()}.}

\item{na_level}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{vector} of \code{integer})\cr indent modifiers for the labels. Each element of the vector
should be a name-value pair with name corresponding to a statistic specified in \code{.stats} and value the indentation
for that statistic's row label.}
}
\value{
A layout object suitable for passing to further layouting functions, or to \code{\link[rtables:build_table]{rtables::build_table()}}.
Adding this function to an \code{rtable} layout will summarize the given variables, arrange the output
in columns, and add it to the table layout.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This analyze function uses the S3 generic function \code{\link[=s_summary]{s_summary()}} to summarize different variables
that are arranged in columns. Additional standard formatting arguments are available. It is a
minimal wrapper for \code{\link[rtables:analyze_colvars]{rtables::analyze_colvars()}}. The latter function is meant to add different
analysis methods for each column variables as different rows. To have the analysis methods as
column labels, please refer to \code{\link[=analyze_vars_in_cols]{analyze_vars_in_cols()}}.
}
\examples{
dta_test <- data.frame(
  USUBJID = rep(1:6, each = 3),
  PARAMCD = rep("lab", 6 * 3),
  AVISIT = rep(paste0("V", 1:3), 6),
  ARM = rep(LETTERS[1:3], rep(6, 3)),
  AVAL = c(9:1, rep(NA, 9)),
  CHG = c(1:9, rep(NA, 9))
)

## Default output within a `rtables` pipeline.
basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("AVISIT") \%>\%
  split_cols_by_multivar(vars = c("AVAL", "CHG")) \%>\%
  summarize_colvars() \%>\%
  build_table(dta_test)

## Selection of statistics, formats and labels also work.
basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("AVISIT") \%>\%
  split_cols_by_multivar(vars = c("AVAL", "CHG")) \%>\%
  summarize_colvars(
    .stats = c("n", "mean_sd"),
    .formats = c("mean_sd" = "xx.x, xx.x"),
    .labels = c(n = "n", mean_sd = "Mean, SD")
  ) \%>\%
  build_table(dta_test)

## Use arguments interpreted by `s_summary`.
basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("AVISIT") \%>\%
  split_cols_by_multivar(vars = c("AVAL", "CHG")) \%>\%
  summarize_colvars(na.rm = FALSE) \%>\%
  build_table(dta_test)

}
\seealso{
\code{\link[rtables:split_cols_by_multivar]{rtables::split_cols_by_multivar()}} and \code{\link{analyze_colvars_functions}}.
}
