% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaplan_meier_plot.R
\name{h_xticks}
\alias{h_xticks}
\title{Helper function: x tick positions}
\usage{
h_xticks(data, xticks = NULL, max_time = NULL)
}
\arguments{
\item{data}{(\code{data.frame})\cr survival data as pre-processed by \code{h_data_plot}.}

\item{xticks}{(\code{numeric}, \code{number}, or \code{NULL})\cr numeric vector of ticks or single number with spacing
between ticks on the x axis. If \code{NULL} (default), \code{\link[labeling:extended]{labeling::extended()}} is used to determine
an optimal tick position on the x axis.}

\item{max_time}{(\code{numeric})\cr maximum value to show on X axis. Only data values less than or up to
this threshold value will be plotted (defaults to \code{NULL}).}
}
\value{
A vector of positions to use for x-axis ticks on a \code{ggplot} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Calculate the positions of ticks on the x-axis. However, if \code{xticks} already
exists it is kept as is. It is based on the same function \code{ggplot2} relies on,
and is required in the graphic and the patient-at-risk annotation table.
}
\examples{
\donttest{
library(dplyr)
library(survival)

data <- tern_ex_adtte \%>\%
  filter(PARAMCD == "OS") \%>\%
  survfit(form = Surv(AVAL, 1 - CNSR) ~ ARMCD, data = .) \%>\%
  h_data_plot()

h_xticks(data)
h_xticks(data, xticks = seq(0, 3000, 500))
h_xticks(data, xticks = 500)
h_xticks(data, xticks = 500, max_time = 6000)
h_xticks(data, xticks = c(0, 500), max_time = 300)
h_xticks(data, xticks = 500, max_time = 300)
}

}
