% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_functions.R
\name{format_fraction_threshold}
\alias{format_fraction_threshold}
\title{Formatting Fraction with Lower Threshold}
\usage{
format_fraction_threshold(threshold)
}
\arguments{
\item{threshold}{(\code{proportion})\cr lower threshold.}
}
\value{
An \code{rtables} formatting function that takes numeric input \code{x} where the second
element is the fraction that is formatted. If the fraction is above or equal to the threshold,
then it is displayed in percentage. If it is positive but below the threshold, it returns,
e.g. "<1" if the threshold is \code{0.01}. If it is zero, then just "0" is returned.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Formats a fraction when the second element of the input \code{x} is the fraction. It applies
a lower threshold, below which it is just stated that the fraction is smaller than that.
}
\examples{
format_fun <- format_fraction_threshold(0.05)
format_fun(x = c(20, 0.1))
format_fun(x = c(2, 0.01))
format_fun(x = c(0, 0))

}
\seealso{
Other formatting functions: 
\code{\link{extreme_format}},
\code{\link{format_count_fraction_fixed_dp}()},
\code{\link{format_count_fraction}()},
\code{\link{format_extreme_values_ci}()},
\code{\link{format_extreme_values}()},
\code{\link{format_fraction_fixed_dp}()},
\code{\link{format_fraction}()},
\code{\link{format_xx}()},
\code{\link{formatting_functions}}
}
\concept{formatting functions}
