% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abnormal_by_baseline.R
\name{abnormal_by_baseline}
\alias{abnormal_by_baseline}
\alias{s_count_abnormal_by_baseline}
\alias{a_count_abnormal_by_baseline}
\alias{count_abnormal_by_baseline}
\title{Patient Counts with Abnormal Range Values by Baseline Status}
\usage{
s_count_abnormal_by_baseline(
  df,
  .var,
  abnormal,
  na_level = "<Missing>",
  variables = list(id = "USUBJID", baseline = "BNRIND")
)

a_count_abnormal_by_baseline(
  df,
  .var,
  abnormal,
  na_level = "<Missing>",
  variables = list(id = "USUBJID", baseline = "BNRIND")
)

count_abnormal_by_baseline(
  lyt,
  var,
  abnormal,
  ...,
  table_names = abnormal,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var, var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{abnormal}{(\code{character})\cr identifying the abnormal range level(s) in \code{.var}.}

\item{na_level}{(\code{string})\cr the explicit \code{na_level} argument you used in the pre-processing steps (maybe with
\code{\link[=df_explicit_na]{df_explicit_na()}}). The default is \code{"<Missing>"}.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{...}{additional arguments for the lower level functions.}

\item{table_names}{(\code{character})\cr this can be customized in case that the same \code{vars} are analyzed multiple times,
to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}
}
\value{
\itemize{
\item \code{s_count_abnormal_by_baseline()} returns statistic \code{fraction} which is a named list with 3 labeled elements:
\code{not_abnormal}, \code{abnormal}, and \code{total}. Each element contains a vector with \code{num} and \code{denom} patient counts.
}

\itemize{
\item \code{a_count_abnormal_by_baseline()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

\itemize{
\item \code{count_abnormal_by_baseline()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_count_abnormal_by_baseline()} to the table layout.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Primary analysis variable \code{.var} indicates the abnormal range result (\code{character} or \code{factor}), and additional
analysis variables are \code{id} (\code{character} or \code{factor}) and \code{baseline} (\code{character} or \code{factor}). For each
direction specified in \code{abnormal} (e.g. high or low) we condition on baseline range result and count
patients in the numerator and denominator as follows:
\itemize{
\item \verb{Not <Abnormal>}
\itemize{
\item \code{denom}: the number of patients without abnormality at baseline (excluding those with missing baseline)
\item \code{num}:  the number of patients in \code{denom} who also have at least one abnormality post-baseline
}
\item \verb{<Abnormal>}
\itemize{
\item \code{denom}: the number of patients with abnormality at baseline
\item \code{num}: the number of patients in \code{denom} who also have at least one abnormality post-baseline
}
\item \code{Total}
\itemize{
\item \code{denom}: the number of patients with at least one valid measurement post-baseline
\item \code{num}: the number of patients in \code{denom} who also have at least one abnormality post-baseline
}
}
}
\section{Functions}{
\itemize{
\item \code{s_count_abnormal_by_baseline()}: Statistics function for a single \code{abnormal} level.

\item \code{a_count_abnormal_by_baseline()}: Formatted analysis function which is used as \code{afun}
in \code{count_abnormal_by_baseline()}.

\item \code{count_abnormal_by_baseline()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

}}
\note{
\itemize{
\item \code{df} should be filtered to include only post-baseline records.
\item If the baseline variable or analysis variable contains \code{NA}, it is expected that \code{NA} has been
conveyed to \code{na_level} appropriately beforehand with \code{\link[=df_explicit_na]{df_explicit_na()}} or \code{\link[=explicit_na]{explicit_na()}}.
}
}
\examples{
df <- data.frame(
  USUBJID = as.character(c(1:6)),
  ANRIND = factor(c(rep("LOW", 4), "NORMAL", "HIGH")),
  BNRIND = factor(c("LOW", "NORMAL", "HIGH", NA, "LOW", "NORMAL"))
)
df <- df_explicit_na(df)

# Layout creating function.
basic_table() \%>\%
  count_abnormal_by_baseline(var = "ANRIND", abnormal = c(High = "HIGH")) \%>\%
  build_table(df)

# Passing of statistics function and formatting arguments.
df2 <- data.frame(
  ID = as.character(c(1, 2, 3, 4)),
  RANGE = factor(c("NORMAL", "LOW", "HIGH", "HIGH")),
  BLRANGE = factor(c("LOW", "HIGH", "HIGH", "NORMAL"))
)

basic_table() \%>\%
  count_abnormal_by_baseline(
    var = "RANGE",
    abnormal = c(Low = "LOW"),
    variables = list(id = "ID", baseline = "BLRANGE"),
    .formats = c(fraction = "xx / xx"),
    .indent_mods = c(fraction = 2L)
  ) \%>\%
  build_table(df2)

}
\seealso{
Relevant description function \code{\link[=d_count_abnormal_by_baseline]{d_count_abnormal_by_baseline()}}.
}
\keyword{internal}
