% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npdims.R
\name{npdims}
\alias{npdims}
\alias{npdims.term}
\title{Number of Parameter Dimensions}
\usage{
npdims(x, ...)

\method{npdims}{term}(x, terms = FALSE, ...)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}

\item{terms}{A flag specifying whether to get the number of dimensions for each term element.}
}
\value{
A named integer vector of the number of dimensions of each parameter.
}
\description{
Gets the number of parameter dimensions of an object as returned by \code{\link[=pdims]{pdims()}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{term}: Number of parameter dimensions of term vector
}}

\examples{
npdims(as.term(c("alpha[1]", "alpha[3]", "beta[1,1]", "beta[2,1]")))
npdims(as.term(c("alpha[1]", "alpha[3]", "beta[1,1]", "beta[2,1]")), terms = TRUE)
}
\seealso{
\code{\link[=pdims]{pdims()}} and \code{\link[=term-vector]{term-vector()}}
}
