% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.r, R/sptensor.r
\docType{methods}
\name{sptensor}
\alias{sptensor}
\alias{sptensor,matrix,ANY,numeric-method}
\alias{sptensor,matrix,missing,numeric-method}
\alias{sptensor,list,ANY,numeric-method}
\title{Construct a sparse tensor}
\usage{
sptensor(subs, vals, dims)

\S4method{sptensor}{matrix,ANY,numeric}(subs, vals, dims)

\S4method{sptensor}{matrix,missing,numeric}(subs, vals, dims)

\S4method{sptensor}{list,ANY,numeric}(subs, vals, dims)
}
\arguments{
\item{subs}{matrix with length(dims) rows and length(vals) cols. Each row
in the matrix corresponds to a different tensor dimension. Each column in the
 matrix represents a vector of subscripts pointing to a non-zero value in the
  tensor.}

\item{vals}{values of non-zero entries. The subscripts for the first value
are the first column of the \code{subs} matrix, the subscripts for the second value
are in the second column of the \code{subs} matrix, etc...}

\item{dims}{sizes of each dimension}
}
\description{
Construct an \linkS4class{sptensor} from a matrix of subscripts for non-zero values,
a vector of non-zero values, and the numeric dimensions of the tensor.
}
\examples{
# A 2x2x2 sparse tensor
subs <- matrix(c(1,1,1, 1,1,2), c(3,2))
vals <- c(10,20)
dims <- c(2,2,2)
X <- sptensor(subs, vals, dims)

}
\seealso{
\code{\link{sptensor-class}} for class documentation.
}
