% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tds.R
\encoding{UTF-8}
\name{get.differences}
\alias{get.differences}
\title{Get vector of difference in dominance rates}
\usage{
get.differences(x, y)
}
\arguments{
\item{x}{matrix of dominance indicators for a single product\code{x}attribute (rows = evaluations, columns = times)}

\item{y}{matrix of dominance indicators for a different product (same attribute)}
}
\value{
out vector of differences in dominance rates
}
\description{
Get vector of difference in dominance rates
}
\examples{
# example using 'bars' data set
bars.m <- aggregate(bars[, -c(1:4)], list(samples = bars$sample, attribute = bars$attribute), mean)
bars.m <- bars.m[order(bars.m$sample, bars.m$attribute), ]
attributes <- unique(bars$attribute)
times <- get.times(colnames(bars.m)[-c(1:2)])
bar1 <- bars.m[bars.m$sample == 1 & bars.m$attribute == "Caramelized Flavour", -c(1:2)]
bar2 <- bars.m[bars.m$sample == 2 & bars.m$attribute == "Caramelized Flavour", -c(1:2)]
b.diff <- get.differences(bar1, bar2)
round(b.diff, 3)

# toy example
x <- data.frame(t10 = c( NA,  0,  0,  0,  1,  1,  0,  0,  1,  0, NA),
                t15 = c(  1,  0,  0,  1,  1,  1,  0,  1,  0,  1,  0),
                t20 = c(  1,  1,  1,  1,  1,  1,  1,  0,  1, NA,  0))
y <- data.frame(t10 = c( NA, NA,  0,  0,  1,  1,  0,  0,  0,  0, NA),
                t15 = c(  0,  0,  0,  0,  1,  0,  1,  1,  0,  1,  1),
                t20 = c(  1,  0,  1,  1,  0,  0,  1, NA,  1, NA,  0))
get.differences(x, y)
}
\references{
Pineau, N., Schlich, P., Cordelle, S., Mathonnière, C., Issanchou, S., Imbert, A., Rogeaux, M., Etiévant, P., & Köster, E. (2009). Temporal dominance of sensations: Construction of the TDS curves and comparison with time–intensity.  \emph{Food Quality and Preference}, 20, 450–455. \doi{10.1016/j.foodqual.2009.04.005}
}
