% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calls_combine_by.R
\name{calls_combine_by}
\alias{calls_combine_by}
\title{Compose predicates}
\usage{
calls_combine_by(calls, operator)
}
\arguments{
\item{calls}{(\code{list})
containing calls (or symbols) to be combined by \code{operator}}

\item{operator}{(\code{character(1)})
infix operator to use in predicate composition, \emph{e.g.} \code{"&"}}
}
\value{
A \code{call} where elements of \code{calls} are composed with \code{operator} or \code{NULL} if \code{calls} is an empty list.
}
\description{
Combines calls with a logical operator.
}
\details{
This function is used to combine logical predicates produced by \code{FilterState} objects
to build a complete subset expression.
}
\keyword{internal}
