% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_a_pca.R
\name{tm_a_pca}
\alias{tm_a_pca}
\title{\code{teal} module: Principal component analysis}
\usage{
tm_a_pca(
  label = "Principal Component Analysis",
  dat,
  plot_height = c(600, 200, 2000),
  plot_width = NULL,
  ggtheme = c("gray", "bw", "linedraw", "light", "dark", "minimal", "classic", "void"),
  ggplot2_args = teal.widgets::ggplot2_args(),
  rotate_xaxis_labels = FALSE,
  font_size = c(12, 8, 20),
  alpha = c(1, 0, 1),
  size = c(2, 1, 8),
  pre_output = NULL,
  post_output = NULL
)
}
\arguments{
\item{label}{(\code{character(1)}) Label shown in the navigation item for the module or module group.
For \code{modules()} defaults to \code{"root"}. See \code{Details}.}

\item{dat}{(\code{data_extract_spec} or \code{list} of multiple \code{data_extract_spec})
specifying columns used to compute PCA.}

\item{plot_height}{(\code{numeric}) optional, specifies the plot height as a three-element vector of
\code{value}, \code{min}, and \code{max} intended for use with a slider UI element.}

\item{plot_width}{(\code{numeric}) optional, specifies the plot width as a three-element vector of
\code{value}, \code{min}, and \code{max} for a slider encoding the plot width.}

\item{ggtheme}{(\code{character}) optional, \code{ggplot2} theme to be used by default. Defaults to \code{"gray"}.}

\item{ggplot2_args}{(\code{ggplot2_args}) optional, object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}}
with settings for all the plots or named list of \code{ggplot2_args} objects for plot-specific settings.
The argument is merged with options variable \code{teal.ggplot2_args} and default module setup.

List names should match the following: \code{c("default", "Elbow plot", "Circle plot", "Biplot", "Eigenvector plot")}.

For more details see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}

\item{rotate_xaxis_labels}{(\code{logical}) optional, whether to rotate plot X axis labels. Does not
rotate by default (\code{FALSE}).}

\item{font_size}{(\code{numeric}) optional, specifies font size.
It controls the font size for plot titles, axis labels, and legends.
\itemize{
\item If vector of \code{length == 1} then the font sizes will have a fixed size.
\item while vector of \code{value}, \code{min}, and \code{max} allows dynamic adjustment.
}}

\item{alpha}{(\code{integer(1)} or \code{integer(3)}) optional, specifies point opacity.
\itemize{
\item When the length of \code{alpha} is one: the plot points will have a fixed opacity.
\item When the length of \code{alpha} is three: the plot points opacity are dynamically adjusted based on
vector of \code{value}, \code{min}, and \code{max}.
}}

\item{size}{(\code{integer(1)} or \code{integer(3)}) optional, specifies point size.
\itemize{
\item When the length of \code{size} is one: the plot point sizes will have a fixed size.
\item When the length of \code{size} is three: the plot points size are dynamically adjusted based on
vector of \code{value}, \code{min}, and \code{max}.
}}

\item{pre_output}{(\code{shiny.tag}) optional, text or UI element to be displayed before the module's output,
providing context or a title.
with text placed before the output to put the output into context. For example a title.}

\item{post_output}{(\code{shiny.tag}) optional, text or UI element to be displayed after the module's output,
adding context or further instructions. Elements like \code{shiny::helpText()} are useful.}
}
\value{
Object of class \code{teal_module} to be used in \code{teal} applications.
}
\description{
Module conducts principal component analysis (PCA) on a given dataset and offers different
ways of visualizing the outcomes, including elbow plot, circle plot, biplot, and eigenvector plot.
Additionally, it enables dynamic customization of plot aesthetics, such as opacity, size, and
font size, through UI inputs.
}
\examples{
library(teal.widgets)

# general data example
data <- teal_data()
data <- within(data, {
  require(nestcolor)
  USArrests <- USArrests
})

datanames(data) <- "USArrests"

app <- init(
  data = data,
  modules = modules(
    tm_a_pca(
      "PCA",
      dat = data_extract_spec(
        dataname = "USArrests",
        select = select_spec(
          choices = variable_choices(
            data = data[["USArrests"]], c("Murder", "Assault", "UrbanPop", "Rape")
          ),
          selected = c("Murder", "Assault"),
          multiple = TRUE
        ),
        filter = NULL
      ),
      ggplot2_args = ggplot2_args(
        labs = list(subtitle = "Plot generated by PCA Module")
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

# CDISC data example
data <- teal_data()
data <- within(data, {
  require(nestcolor)
  ADSL <- rADSL
})
datanames(data) <- "ADSL"
join_keys(data) <- default_cdisc_join_keys[datanames(data)]

app <- init(
  data = data,
  modules = modules(
    tm_a_pca(
      "PCA",
      dat = data_extract_spec(
        dataname = "ADSL",
        select = select_spec(
          choices = variable_choices(
            data = data[["ADSL"]], c("BMRKR1", "AGE", "EOSDY")
          ),
          selected = c("BMRKR1", "AGE"),
          multiple = TRUE
        ),
        filter = NULL
      ),
      ggplot2_args = ggplot2_args(
        labs = list(subtitle = "Plot generated by PCA Module")
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
