% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{bayes_control}
\alias{bayes_control}
\title{Bayesian closed-loop control}
\usage{
bayes_control(
  targets,
  updates,
  prior,
  true_pars,
  pkmod = pkmod3cptm,
  pdmod = emax_eleveld,
  pdinv = inv_emax_eleveld,
  init0 = NULL,
  init_p = NULL,
  obs_tms = NULL,
  dt_obs = 1/6,
  sim_starttm = 0,
  tci_alg = "effect",
  print_progress = FALSE
)
}
\arguments{
\item{targets}{Data frame with columns ("time","target")}

\item{updates}{Data frame of times at which closed-loop updates should be conducted and
optional variable with logical values named 'full_data' indicating if full updates should
be used. Defaults to partial.}

\item{prior}{List with elements "mu" and "sig" specifying the prior mean and covariance
matrices for the logged parameter values.}

\item{true_pars}{Vector of true patient PK-PD parameters.}

\item{pkmod}{PK model}

\item{pdmod}{PD model}

\item{pdinv}{Inverse PD model}

\item{init0}{True initial concentrations}

\item{init_p}{Predicted initial concentrations}

\item{obs_tms}{Times at which observations are collected. If null, observations will be
made at fixed intervals specified by 'dtm'.}

\item{dt_obs}{Interval between measurements.}

\item{sim_starttm}{Start time of simulation}

\item{tci_alg}{TCI algorithm used. Defaults to effect-site targeting.}

\item{print_progress}{Logical. Should current update times be printed to the console.}
}
\value{
list with class "bayessim" containing results of closed-loop simulation.
}
\description{
Function to provide Bayesian closed-loop control.
}
