% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poppk_mods.R
\name{marsh_poppk}
\alias{marsh_poppk}
\title{Marsh population PK model.}
\usage{
marsh_poppk(df, rate = TRUE)
}
\arguments{
\item{df}{data frame with column titled "TBM" giving patient total body
mass in kg.}

\item{rate}{Logical. Should elimination rate constants be returned instead
of clearance parameters.}
}
\value{
Returns the original data frame entered into function with additional columns appended
describing patient PK parameter values.
}
\description{
Takes in a data frame with a column labeled "TBM" providing the total
body mass of patients. The function returns the original data frame with additional
columns describing estimated patient PK parameters based on the Marsh population PK
model. The effect-site elimination parameter, KE0, is set to 1.2 in accordance with
recommendations from Absalom et al., 2009 "Pharmacokinetic models for propofol-
Defining and illuminating the devil in the detail"
}
\details{
------------------------------------------------------------------------------------
Population PK and PK-PD functions --------------------------------------------------
------------------------------------------------------------------------------------
}
