% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/crosses.R
\name{intersect}
\alias{intersect}
\alias{intersectCount}
\alias{intersectIndices}
\alias{intersectLogic}
\title{Intersection between sets of sequences or any elements.}
\usage{
intersect(.alpha = NULL, .beta = NULL, .type = "00e", .head = -1, .norm = F,
          .verbose = F, x = NULL, y = NULL)

intersectCount(.alpha, .beta, .method = c('exact', 'hamm', 'lev'), .col = NULL)

intersectIndices(.alpha, .beta, .method = c('exact', 'hamm', 'lev'), .col = NULL)

intersectLogic(.alpha, .beta, .method = c('exact', 'hamm', 'lev'), .col = NULL)
}
\arguments{
\item{.alpha}{Either first vector or data.frame or list with data.frames.}

\item{.beta}{Second vector or data.frame or type of intersection procedure (see the \code{.type} parameter) if \code{.alpha} is a list.}

\item{.type}{Types of intersection procedure if \code{.alpha} and \code{.beta} is data frames. String with 3 characters (see 'Details' for more information).}

\item{.head}{Parameter for the \code{head} function, applied before intersecting.}

\item{.norm}{If TRUE than normalise result by product of length or nrows of the given data.}

\item{.verbose}{If T than produce output of processing the data.}

\item{x,y}{Parameters leaved for compatability with code which uses \code{base::intersect}. If provided than replaces \code{.alpha} and \code{.beta} respectively.}

\item{.method}{Method to use for intersecting string elements: 'exact' for exact matching, 'hamm' for matching strings which have <= 1 hamming distance,
'lev' for matching strings which have <= 1 levenshtein (edit) distance between them.}

\item{.col}{Which columns use for fetching values to intersect. First supplied column matched with \code{.method}, others as exact values.}
}
\value{
\code{intersect} returns (normalised) number of similar elements or matrix with numbers of elements.

\code{intersectCount} returns number of similar elements.

\code{intersectIndices} returns 2-row matrix with the first column stands for an index of an element in the given \code{x}, and the second column stands for an index of an element of \code{y} which is similar to a relative element in \code{x};

\code{intersectLogic} returns logical vector of \code{length(x)} or \code{nrow(x)}, where TRUE at position \code{i} means that element with index {i} has been found in the \code{y}
}
\description{
Functions for the intersection of data frames with TCR / BCR data.

\code{intersect} - overwrites \code{base::intersect} function. If supplied with parameters \code{x} and \code{y},
than runs \code{base::intersect} on them. If not, than returns number of similar elements in the given objects or matrix
with count of similar elements among each objects in the given list.

\code{intersectCount} - similar to \code{tcR::intersect}, but with fewer parameters and only for two objects.

\code{intersectIndices} - returns matrix M with two columns, where element with index M[i, 1] in the first
given object is similar to an element with index M[i, 2] in the second given object.

\code{intersectLogic} - returns logic vector with TRUE values in positions, where element in the first given data frame
is found in the second given data frame.
}
\details{
Parameter \code{.type} of the \code{cross} function is a string of length 3
[0an][0vja][ehl], where:
\enumerate{
 \item First character defines which elements intersect ("a" for elements from the column "CDR3.amino.acid.sequence",
 "n" for elements from the column "CDR3.nucleotide.sequence", other characters - intersect elements as specified);
 \item Second character defines which columns additionaly script should use
('0' for cross with no additional columns, 'v' for cross using the "V.segments" column,
'j' for cross using "J.segments" column, 'a' for cross using both "V.segments" and "J.segments" columns);
 \item Third character defines a method of search for similar sequences is use:
 "e" stands for the exact match of sequnces, "h" for match elements which have the Hamming distance between them
 equal to or less than 1, "l" for match elements which have the Levenshtein distance between tham equal to or less than 1.
}
}
\examples{
data(twb)
# Equivalent to intersect(twb[[1]]$CDR3.nucleotide.sequence,
#                         twb[[2]]$CDR3.nucleotide.sequence)
# or intersectCount(twb[[1]]$CDR3.nucleotide.sequence,
#                    twb[[2]]$CDR3.nucleotide.sequence)
# First "n" stands for a "CDR3.nucleotide.sequence" column, "e" for exact match.
twb.12.n0e <- intersect(twb[[1]], twb[[2]], 'n0e')
stopifnot(twb.12.n0e == 46)
# First "a" stands for "CDR3.amino.acid.sequence" column.
# Second "v" means that intersect should also use the "V.segments" column.
intersect(twb[[1]], twb[[2]], 'ave')
# Works also on lists, performs all possible pairwise intersections.
intersect(twb, 'ave')
# Plot results.
vis.heatmap(intersect(twb, 'ave'), .title = 'twb - (ave)-intersection', .labs = '')
# Get elements which are in both twb[[1]] and twb[[2]].
# Elements are tuples of CDR3 nucleotide sequence and corresponding V-segment
imm.1.2 <- intersectLogic(twb[[1]], twb[[2]],
                           .col = c('CDR3.amino.acid.sequence', 'V.segments'))
head(twb[[1]][imm.1.2, c('CDR3.amino.acid.sequence', 'V.segments')])
}
\seealso{
\link{vis.heatmap}, \link{vis.group.boxplot}
}

