% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/infoanalysis.R
\name{entropy.seg}
\alias{entropy.seg}
\alias{js.div.seg}
\title{Repertoires' analysis using information measures applied to V- and J- segment frequencies.}
\usage{
entropy.seg(.data, .frame = c('all', 'in', 'out'),
            .alphabet = if (.VJ) "beta" else 'TRBV', .meat = F, .other = T, .VJ = F)

js.div.seg(.data, .data2 = NULL, .frame = c('all', 'in', 'out'), .norm.entropy = T,
           .alphabet = if (.VJ) "beta" else 'TRBV', .meat = F, .other = T, .VJ = F,
           .verbose = T)
}
\arguments{
\item{.data}{Mitcr data.frame or a list with mitcr data.frames.}

\item{.frame}{Character vector of length 1 specified which *-frames should be used:
only in-frame ('in'), out-of-frame ('out') or all sequences ('all').}

\item{.alphabet}{Parameter to \code{freq.segments()} and \code{freq.segments.2D()} functions.}

\item{.meat}{Parameter to \code{freq.segments()} and \code{freq.segments.2D()} functions.}

\item{.other}{Parameter to \code{freq.segments()} and \code{freq.segments.2D()} functions.}

\item{.VJ}{If F than apply \code{freq.segments} function, else apply \code{freq.segments.2D} function.}

\item{.data2}{NULL if .data is a list, or a second mitcr data.frame.}

\item{.norm.entropy}{If T than divide result by mean entropy of 2 segments' frequencies.}

\item{.verbose}{If T than print progress of function executing.}
}
\value{
For \code{entropy.seg} - numeric integer with entropy value(s). For \code{js.div.seg} - integer of vector one if \code{.data} and \code{.data2} are provided;
esle matrix length(.data) X length(.data) if \code{.data} is a list.
}
\description{
Information approach to repertoire analysis. Function \code{entropy.seg} applies Shannon entropy to V-usage and hence measures variability of V-usage.
Function \code{js.div.seg} applied Jensen-Shannon divergence to V-usage of two or more data frames and hence measures distance among this V-usages.
}
\seealso{
\link{vis.heatmap}, \link{vis.group.boxplot}, \link{freq.segments}
}

