% Generated by roxygen2 (4.0.2): do not edit by hand
\name{pca.segments}
\alias{pca.segments}
\alias{pca.segments.2D}
\title{Perform PCA on segments frequency data.}
\usage{
pca.segments(.data, .cast.freq.seg = T, ..., .do.plot = T)

pca.segments.2D(.data, .cast.freq.seg = T, ..., .do.plot = T)
}
\arguments{
\item{.data}{Either data.frame or a list of data.frame or a result obtained from freq.segments or freq.segments.2D functions.}

\item{.cast.freq.seg}{If T than case freq.segments or freq.segments.2D to the supplied data.}

\item{...}{Further arguments passed to prcomp.}

\item{.do.plot}{If T than plot a graphic, else return a pca object.}
}
\value{
If .do.plot is T than ggplot object; else pca object.
}
\description{
Perform PCA on segments frequency data for V- and J-segments and either return pca object or plot the results.
}
\examples{
\dontrun{
# Load the twins data.
data(twb)
# Plot a plot of results of PCA on V-segments usage.
pca.segments(twb, T, scale. = T)
}
}

