% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxo2doc.R
\name{taxo2doc}
\alias{taxo2doc}
\title{Taxolist to document}
\usage{
taxo2doc(
  taxolist = NULL,
  genus = NA,
  family = NA,
  title = "",
  addsource = TRUE,
  mastersource = "",
  duplicatesyn = TRUE,
  sourcecol = c("black", "blue"),
  outformat = "html_document",
  outdir = ".",
  outfile = "taxolist.html"
)
}
\arguments{
\item{taxolist}{taxolist}

\item{genus}{only process for specific genus. Default("") implying process 
all}

\item{family}{only process for specific family. Default("") implying process 
all}

\item{title}{List title you want to print in output header}

\item{addsource}{boolean If the source tag should be displayed. Default TRUE}

\item{mastersource}{source string for the master list}

\item{duplicatesyn}{boolean if synonyms should to displayed in their 
alphabetical sorted position too. Dafault TRUE}

\item{sourcecol}{vector of text color values for each source value}

\item{outformat}{output format one of "html_document", "word_document",
"odt_document", "rtf_document", "pdf_document". Default ("html_document")}

\item{outdir}{output directory for the document. Default (".")}

\item{outfile}{output file name. Dedfaout ("taxolist.html")}
}
\value{
NULL Saves a document file
}
\description{
Converts a taxolist to a formatted document in html, pdf or
word document
}
\details{
Converts a taxolist to a formatted document in html, pdf or
word document making it easy for taxonomist to read through the data
}
\examples{
\donttest{
mytaxo <- data.frame("id" = c(1,2,3,4,5,6,7),
                    "canonical" = c("Hypochlorosis ancharia",
                                    "Hypochlorosis tenebrosa",
                                    "Pseudonotis humboldti",
                                    "Myrina ancharia",
                                    "Hypochlorosis ancharia tenebrosa",
                                    "Hypochlorosis ancharia obiana",
                                    "Hypochlorosis lorquinii"),
                     "family" = c("Lycaenidae", "Lycaenidae", "Lycaenidae",
                                  "Lycaenidae", "Lycaenidae", "Lycaenidae",
                                  "Lycaenidae"),
                    "accid" = c(0,1,1,1,0,0,0),
                    "source" = c("itis","itis","wiki","wiki","itis",
                                 "itis","itis"),
                    stringsAsFactors = FALSE)
taxo2doc(mytaxo)
taxo2doc(mytaxo,source="My list")
}
}
\seealso{
Other List functions: 
\code{\link{DwC2taxo}()},
\code{\link{cast_cs_field}()},
\code{\link{compact_ids}()},
\code{\link{get_synonyms}()},
\code{\link{match_lists}()},
\code{\link{melt_cs_field}()},
\code{\link{merge_lists}()},
\code{\link{syn2taxo}()},
\code{\link{synonymize_subspecies}()},
\code{\link{taxo2DwC}()},
\code{\link{taxo2syn}()},
\code{\link{wiki2taxo}()}
}
\concept{List functions}
