% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eol_pages.R
\name{eol_pages}
\alias{eol_pages}
\title{Search for pages in EOL database using a taxonconceptID.}
\usage{
eol_pages(
  taxonconceptID,
  images_per_page = NULL,
  images_page = NULL,
  videos_per_page = NULL,
  videos_page = NULL,
  sounds_per_page = NULL,
  sounds_page = NULL,
  maps_per_page = NULL,
  maps_page = NULL,
  texts_per_page = NULL,
  texts_page = NULL,
  subjects = "overview",
  licenses = "all",
  details = FALSE,
  common_names = FALSE,
  synonyms = FALSE,
  references = FALSE,
  taxonomy = TRUE,
  vetted = 0,
  cache_ttl = NULL,
  key = NULL,
  ...
)
}
\arguments{
\item{taxonconceptID}{(numeric) a taxonconceptID, which is also the page
number}

\item{images_per_page}{(integer) number of returned image objects (0-75)}

\item{images_page}{(integer) images page}

\item{videos_per_page}{(integer) number of returned video objects (0-75)}

\item{videos_page}{(integer) videos page}

\item{sounds_per_page}{(integer) number of returned sound objects (0-75)}

\item{sounds_page}{(integer) sounds page}

\item{maps_per_page}{(integer) number of returned map objects (0-75)}

\item{maps_page}{(integer) maps page}

\item{texts_per_page}{(integer) number of returned text objects (0-75)}

\item{texts_page}{(integer) texts page}

\item{subjects}{'overview' (default) to return the overview text
(if exists), a pipe | delimited list of subject names from the list of EOL
accepted subjects (e.g. TaxonBiology, FossilHistory), or 'all' to get text
in any subject. Always returns an overview text as a first result (if one
exists in the given context).}

\item{licenses}{A pipe | delimited list of licenses or 'all' (default) to
get objects under any license. Licenses abbreviated cc- are all Creative
Commons licenses. Visit their site for more information on the various
licenses they offer.}

\item{details}{Include all metadata for data objects. (Default: \code{FALSE})}

\item{common_names}{Return all common names for the page's taxon
(Default: \code{FALSE})}

\item{synonyms}{Return all synonyms for the page's taxon
(Default: \code{FALSE})}

\item{references}{Return all references for the page's taxon
(Default: \code{FALSE})}

\item{taxonomy}{(logical) Whether to return any taxonomy details from
different taxon hierarchy providers, in an array named \code{taxonconcepts}
(Default: \code{TRUE})}

\item{vetted}{If 'vetted' is given a value of '1', then only trusted
content will be returned. If 'vetted' is '2', then only trusted and
unreviewed content will be returned (untrusted content will not be returned).
The default is to return all content. (Default: \code{FALSE})}

\item{cache_ttl}{The number of seconds you wish to have the response cached.}

\item{key}{Your EOL API key; see \link{taxize-authentication}
for help on authentication}

\item{...}{Curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
JSON list object, or data.frame.
}
\description{
Search for pages in EOL database using a taxonconceptID.
}
\details{
It's possible to return JSON or XML with the EOL API. However,
this function only returns JSON for now.
}
\examples{
\dontrun{
(pageid <- eol_search('Pomatomus')$pageid[1])
x <- eol_pages(taxonconceptID = pageid)
x
x$scinames

z <- eol_pages(taxonconceptID = pageid, synonyms = TRUE)
z$synonyms

z <- eol_pages(taxonconceptID = pageid, common_names = TRUE)
z$vernacular
}
}
