% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{internodes}
\alias{internodes}
\title{Get "internode" taxa}
\arguments{
\item{obj}{The \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object containing taxon
information to be queried.}

\item{subset}{Taxon IDs, TRUE/FALSE vector, or taxon indexes used to subset the tree prior to
determining internodes. Default: All taxa in \code{obj} will be used. Any variable
name that appears in \code{\link[=all_names]{all_names()}} can be used as if it was a vector on its
own. Note that internodes are determined after the filtering, so a given
taxon might be a internode on the unfiltered tree, but not a internode
on the filtered tree.}

\item{value}{What data to return. This is usually the name of column in a
table in \code{obj$data}. Any result of \code{\link[=all_names]{all_names()}} can be used, but it
usually only makes sense to use data that corresponds to taxa 1:1, such as
\code{\link[=taxon_ranks]{taxon_ranks()}}. By default, taxon indexes are returned.}
}
\value{
\code{character}
}
\description{
Return the "internode" taxa for a \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object. An
internode is any taxon with a single immediate supertaxon and a single
immediate subtaxon. They can be removed from a tree without any loss of
information on the relative relationship between remaining taxa. Can also be
used to get the internodes of a subset of taxa.
\preformatted{
obj$internodes(subset = NULL, value = NULL)
internodes(obj, subset = NULL, value = NULL)}
}
\examples{
\dontrun{

# Return indexes of branch taxa
internodes(ex_taxmap)

# Return indexes for a subset of taxa
internodes(ex_taxmap, subset = 2:17)
internodes(ex_taxmap, subset = n_obs > 1)

# Return something besides taxon indexes
internodes(ex_taxmap, value = "taxon_names")

}
}
\seealso{
Other taxonomy indexing functions: \code{\link{branches}},
  \code{\link{leaves}}, \code{\link{roots}},
  \code{\link{stems}}, \code{\link{subtaxa}},
  \code{\link{supertaxa}}
}
