% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--docs.R
\name{filter_obs}
\alias{filter_obs}
\title{Filter observations with a list of conditions}
\arguments{
\item{obj}{An object of type \code{\link[=taxmap]{taxmap()}}}

\item{target}{The name of the list/vector/table in \code{obj$data} to filter}

\item{...}{One or more filtering conditions. Any variable name that appears
in \code{\link[=all_names]{all_names()}} can be used as if it was a vector on its own. Each
filtering condition can be one of three things:
\itemize{
\item \code{integer}: One or more row indexes of \code{obj[target]}
\item \code{logical}: A \code{TRUE}/\code{FALSE} vector of length equal to the number of
rows in \code{obj[target]}
}}

\item{drop_taxa}{(\code{logical} of length 1) If \code{FALSE}, preserve taxa
even if all of their observations are filtered out. If \code{TRUE}, remove
taxa for which all observations were filtered out. Note that only taxa that
are unobserved due to this filtering will be removed; there might be other
taxa without observations to begin with that will not be removed.}
}
\value{
An object of type \code{\link[=taxmap]{taxmap()}}
}
\description{
Filter data in a \code{\link[=taxmap]{taxmap()}} object (in \code{obj$data}) with a
set of conditions.  See
\code{\link[dplyr:filter]{dplyr::filter()}} for the inspiration for this function and more
information. Calling the function using the \code{obj$filter_obs(...)} style
edits "obj" in place, unlike most R functions. However, calling the function
using the \code{filter_obs(obj, ...)} imitates R's traditional copy-on-modify
semantics, so "obj" would not be changed; instead a changed version would be
returned, like most R functions.
\preformatted{
obj$filter_obs(target, ..., drop_taxa = FALSE)
filter_obs(obj, target, ..., drop_taxa = FALSE)}
}
\examples{
# Filter by row index
filter_obs(ex_taxmap, "info", 1:2)

# Filter by TRUE/FALSE
filter_obs(ex_taxmap, "info", dangerous == FALSE)

# Remove taxa whose obserservation were filtered out
filter_obs(ex_taxmap, "info", dangerous == FALSE, drop_taxa = TRUE)

}
\seealso{
Other taxmap manipulation functions: \code{\link{arrange_obs}},
  \code{\link{arrange_taxa}}, \code{\link{filter_taxa}},
  \code{\link{mutate_obs}}, \code{\link{sample_frac_obs}},
  \code{\link{sample_frac_taxa}},
  \code{\link{sample_n_obs}}, \code{\link{sample_n_taxa}},
  \code{\link{select_obs}}, \code{\link{transmute_obs}}
}
