% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_progress.R
\name{tar_progress}
\alias{tar_progress}
\title{Read progress.}
\usage{
tar_progress(
  names = NULL,
  fields = "progress",
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{names}{Optional, names of the targets. If supplied, \code{tar_progress()}
only returns progress information on these targets.
You can supply symbols
or \code{tidyselect} helpers like \code{\link[=any_of]{any_of()}} and \code{\link[=starts_with]{starts_with()}}.}

\item{fields}{Optional, names of progress data columns to read.
Set to \code{NULL} to read all fields.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
A data frame with one row per target and the following columns:
\itemize{
\item \code{name}: name of the target.
\item \code{type}: type of target: \code{"stem"} for non-branching targets,
\code{"pattern"} for dynamically branching targets, and \code{"branch"}
for dynamic branches.
\item \code{parent}: name of the target's parent. For branches, this is the
name of the associated pattern. For other targets, the pattern
is just itself.
\item \code{branches}: number of dynamic branches of a pattern. 0 for non-patterns.
\item \code{progress}: the most recent progress update of that target.
Could be \code{"dispatched"}, \code{"completed"}, "\code{skipped}", \code{"canceled"},
or \code{"errored"}. \code{"dispatched"} means the target was sent off
to be run, but in the case of \code{tar_make()} with a \code{crew} controller,
the target might not actually start running right away if the \code{crew}
workers are all busy.
}
}
\description{
Read a project's target progress data for the most recent
run of \code{\link[=tar_make]{tar_make()}} or similar. Only the most recent record is shown.
}
\section{Storage access}{

Several functions like \code{tar_make()}, \code{tar_read()}, \code{tar_load()},
\code{tar_meta()}, and \code{tar_progress()} read or modify
the local data store of the pipeline.
The local data store is in flux while a pipeline is running,
and depending on how distributed computing or cloud computing is set up,
not all targets can even reach it. So please do not call these
functions from inside a target as part of a running
pipeline. The only exception is literate programming
target factories in the \code{tarchetypes} package such as \code{tar_render()}
and \code{tar_quarto()}.


Several functions like \code{tar_make()}, \code{tar_read()}, \code{tar_load()},
\code{tar_meta()}, and \code{tar_progress()} read or modify
the local data store of the pipeline.
The local data store is in flux while a pipeline is running,
and depending on how distributed computing or cloud computing is set up,
not all targets can even reach it. So please do not call these
functions from inside a target as part of a running
pipeline. The only exception is literate programming
target factories in the \code{tarchetypes} package such as \code{tar_render()}
and \code{tar_quarto()}.
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  list(
    tar_target(x, seq_len(2)),
    tar_target(y, 2 * x, pattern = map(x))
  )
}, ask = FALSE)
tar_make()
tar_progress()
tar_progress(starts_with("y_")) # see also any_of()
})
}
}
\seealso{
Other progress: 
\code{\link{tar_canceled}()},
\code{\link{tar_completed}()},
\code{\link{tar_dispatched}()},
\code{\link{tar_errored}()},
\code{\link{tar_poll}()},
\code{\link{tar_progress_branches}()},
\code{\link{tar_progress_summary}()},
\code{\link{tar_skipped}()},
\code{\link{tar_watch}()},
\code{\link{tar_watch_server}()},
\code{\link{tar_watch_ui}()}
}
\concept{progress}
