% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_invalidate.R
\name{tar_invalidate}
\alias{tar_invalidate}
\title{Delete one or more metadata records (e.g. to rerun a target).}
\usage{
tar_invalidate(names, store = targets::tar_config_get("store"))
}
\arguments{
\item{names}{Names of the targets to remove from the metadata list.
The object supplied to \code{names} should be a
\code{tidyselect} expression like \code{\link[=any_of]{any_of()}} or \code{\link[=starts_with]{starts_with()}}
from \code{tidyselect} itself, or \code{\link[=tar_described_as]{tar_described_as()}} to select target names
based on their descriptions.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
\code{NULL} (invisibly).
}
\description{
Delete the metadata of records in \verb{_targets/meta/meta}
but keep the return values of targets in \verb{_targets/objects/}.
}
\details{
This function forces one or more targets to rerun
on the next \code{\link[=tar_make]{tar_make()}}, regardless of the cues and regardless
of how those targets are stored. After \code{tar_invalidate()},
you will still be able to locate the data files with \code{\link[=tar_path_target]{tar_path_target()}}
and manually salvage them in an emergency.
However, \code{\link[=tar_load]{tar_load()}} and \code{\link[=tar_read]{tar_read()}} will not be able to
read the data into R, and subsequent calls to \code{\link[=tar_make]{tar_make()}}
will attempt to rerun those targets.
For patterns recorded in the metadata, all the branches
will be invalidated. For patterns no longer in the metadata,
branches are left alone.
}
\section{Storage access}{

Several functions like \code{tar_make()}, \code{tar_read()}, \code{tar_load()},
\code{tar_meta()}, and \code{tar_progress()} read or modify
the local data store of the pipeline.
The local data store is in flux while a pipeline is running,
and depending on how distributed computing or cloud computing is set up,
not all targets can even reach it. So please do not call these
functions from inside a target as part of a running
pipeline. The only exception is literate programming
target factories in the \code{tarchetypes} package such as \code{tar_render()}
and \code{tar_quarto()}.
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  library(targets)
  library(tarchetypes)
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
}, ask = FALSE)
tar_make()
tar_invalidate(starts_with("y")) # Only invalidates y1 and y2.
tar_make() # y1 and y2 rerun but return same values, so z is up to date.
})
}
}
\seealso{
Other clean: 
\code{\link{tar_delete}()},
\code{\link{tar_destroy}()},
\code{\link{tar_prune}()},
\code{\link{tar_prune_list}()},
\code{\link{tar_unversion}()}
}
\concept{clean}
