% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_crew.R
\name{tar_crew}
\alias{tar_crew}
\title{Get crew worker info.}
\usage{
tar_crew(store = targets::tar_config_get("store"))
}
\arguments{
\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
A data frame one row per \code{crew} worker and the following columns:
\itemize{
\item \code{controller}: name of the \code{crew} controller.
\item \code{worker}: worker index in the controller.
\item \code{launches}: number of times the worker was launched.
\item \code{seconds}: number of seconds the worker spent running tasks.
\item \code{targets}: number of targets the worker completed and delivered.
}
}
\description{
For the most recent run of the pipeline with \code{\link[=tar_make]{tar_make()}}
where a \code{crew} controller was started, get summary-level information
of the workers.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
if (requireNamespace("crew", quietly = TRUE)) {
tar_script({
  tar_option_set(controller = crew::crew_controller_local())
  list(
    tar_target(x, seq_len(2)),
    tar_target(y, 2 * x, pattern = map(x))
  )
}, ask = FALSE)
tar_make()
tar_process()
tar_process(pid)
}
})
}
}
\seealso{
Other data: 
\code{\link{tar_load_everything}()},
\code{\link{tar_load_raw}()},
\code{\link{tar_load}()},
\code{\link{tar_meta}()},
\code{\link{tar_objects}()},
\code{\link{tar_pid}()},
\code{\link{tar_process}()},
\code{\link{tar_read_raw}()},
\code{\link{tar_read}()}
}
\concept{data}
