% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_meta.R
\name{tar_meta}
\alias{tar_meta}
\title{Read a project's metadata.}
\usage{
tar_meta(
  names = NULL,
  fields = NULL,
  targets_only = FALSE,
  complete_only = FALSE
)
}
\arguments{
\item{names}{Optional, names of the targets. If supplied, \code{tar_meta()}
only returns metadata on these targets.
You can supply symbols, a character vector,
or \code{tidyselect} helpers like \code{\link[=starts_with]{starts_with()}}.
If \code{NULL}, all names are selected.}

\item{fields}{Optional, names of columns/fields to select. If supplied,
\code{tar_meta()} only returns the selected metadata columns.
If \code{NULL}, all fields are selected.
You can supply symbols, a character vector, or \code{tidyselect} helpers
like \code{\link[=starts_with]{starts_with()}}. The \code{name} column is always included first
no matter what you select. Choices:
\itemize{
\item \code{name}: name of the target or global object.
\item \code{type}: type of the object: either \code{"function"} or \code{"object"}
for imported global objects, and \code{"stem"}, \code{"branch"},
\code{"map"}, or \code{"cross"} for targets.
\item \code{data}: hash of the output data.
\item \code{command}: hash of the target's deparsed command.
\item \code{depend}: hash of the immediate upstream dependencies of the target.
\item \code{seed}: random number generator seed with which the target was built.
A target's random number generator seed
is a deterministic function of its name. In this way,
each target runs with a reproducible seed so someone else
running the same pipeline should get the same results,
and no two targets in the same pipeline share the same seed.
(Even dynamic branches have different names and thus different seeds.)
You can recover the seed of a completed target
with \code{tar_meta(your_target, seed)} and run \code{set.seed()}
on the result to locally recreate the target's initial RNG state.
\item \code{path}: A list column of paths to target data. Usually, each element
is a single path, but there could be multiple paths per target
for dynamic files (i.e. \code{tar_target(format = "file")}).
\item \code{time}: hash of the maximum modification time stamp
over all the files in \code{path}.
\item \code{size}: hash of the sum of all the bytes of the files at \code{path}.
\item \code{bytes}: total file size in bytes of all files in \code{path}.
\item \code{format}: character, one of the admissible data storage formats.
See the \code{format} argument in the \code{\link[=tar_target]{tar_target()}} help file for details.
\item \code{iteration}: character, either \code{"list"} or \code{"vector"}
to describe the iteration and aggregation mode of the target. See the
\code{iteration} argument in the \code{\link[=tar_target]{tar_target()}} help file for details.
\item \code{parent}: for branches, name of the parent pattern.
\item \code{children}: list column, names of the children of targets that
have them. These include buds of stems and branches of patterns.
\item \code{seconds}: number of seconds it took to run the target.
\item \code{warnings}: character string of warning messages
from the last run of the target.
\item \code{error}: character string of the error message if the target errored.
}}

\item{targets_only}{Logical, whether to just show information about targets
or also return metadata on functions and other global objects.}

\item{complete_only}{Logical, whether to return only complete rows
(no \code{NA} values).}
}
\value{
A data frame with one row per target/object and the selected fields.
}
\description{
Read the metadata of all recorded targets and global objects.
}
\details{
A metadata row only updates when the target is built.
\code{\link[=tar_progress]{tar_progress()}} shows information on targets that are running.
That is why the number of branches may disagree between \code{\link[=tar_meta]{tar_meta()}}
and \code{\link[=tar_progress]{tar_progress()}} for actively running pipelines.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  list(
    tar_target(x, seq_len(2)),
    tar_target(y, 2 * x, pattern = map(x))
  )
}, ask = FALSE)
tar_make()
tar_meta()
tar_meta(starts_with("y_"))
})
}
}
