% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cats.R
\name{read_cats}
\alias{read_cats}
\title{Read a CATS data file and convert to .nc}
\usage{
read_cats(fname, depid)
}
\arguments{
\item{fname}{is the file name of the CATS CSV file including the complete
path name if the file is not in the current working directory or in a
directory on the path. The .csv suffix is optional.}

\item{depid}{is a string containing the deployment identification code assigned
to this deployment, for example, 'mn12_186a'.}
}
\value{
A string (constructed by: '\code{depid}_raw.nc'; for example, 'mn12_186a_raw.nc') containing the file name of the netCDF (.nc) file in which the output has been saved. This function
generates a netCDF file in the current working directory containing
		the tag data variables, including:
		\itemize{
		\item {A, Accelerometer data structure}
		\item {M, Magnetometer data structure}
		\item {temp, Temperature sensor data structure}
		\item {info	Information structure for the deployment}
		}
}
\description{
Read a .csv file with data from a CATS tag deployment, including associated metadata, and store the resulting data in a .nc file.
}
\note{
CATS loggers can produce very large csv files which are slow to
process. This function is (somewhat) optimised for speed and memory use so will
tolerate large files. But processing could ppube slow.
}
\examples{
\dontrun{
nc_filename <- read_cats("my_cats_file.csv", "my_cats_deplyment_name")
load_nc("my_cats_deployment_name_raw.nc")
}
}
