% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tadaa_stats.R
\name{tadaa_t.test}
\alias{tadaa_t.test}
\title{Tadaa, t-Test!}
\usage{
tadaa_t.test(data, response, group, direction = "two.sided", paired = FALSE,
  na.rm = TRUE, print = "df")
}
\arguments{
\item{data}{A \code{data.frame}.}

\item{response}{The response variable (dependent).}

\item{group}{The group variable, usually a \code{factor}.}

\item{direction}{Test direction, like \code{alternative} in \link{t.test}.}

\item{paired}{If \code{TRUE}, a paired t.test is performed with approproate power calculation.}

\item{na.rm}{If \code{TRUE} (default), missing values are dropped.}

\item{print}{Print method, per default a regular \code{data.frame}.
Otherwise passed to \link[pixiedust]{sprinkle_print_method} for fancyness.}
}
\value{
A \code{data.frame} by default, otherwise \code{dust} object, depending on \code{print}.
}
\description{
Tadaa, t-Test!
}
\examples{
df <- data.frame(x = runif(100), y = sample(c("A", "B"), 100, TRUE))
tadaa_t.test(df, x, y)

df <- data.frame(x = runif(100), y = c(rep("A", 50), rep("B", 50)))
tadaa_t.test(df, x, y, paired = TRUE)
}
\seealso{
Other Tadaa-functions: \code{\link{tadaa_aov}},
  \code{\link{tadaa_kruskal}}, \code{\link{tadaa_nom}},
  \code{\link{tadaa_normtest}},
  \code{\link{tadaa_one_sample}}, \code{\link{tadaa_ord}},
  \code{\link{tadaa_wilcoxon}}
}
