% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqmath.zoo.R
\name{qqmath.zoo}
\alias{qqmath.zoo}
\title{Q-Q Plots for Zoo Objects}
\usage{
\method{qqmath}{zoo}(
  x,
  data = NULL,
  xlab = "Theoretical quantiles",
  ylab = "Sample quantiles",
  ref = TRUE,
  ci = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{zoo} object}

\item{data}{Ignored}

\item{xlab}{X axis label}

\item{ylab}{Y axis label}

\item{ref}{Plot a reference line via \code{\link[lattice:panel.qqmathline]{lattice::panel.qqmathline()}}.}

\item{ci}{Plot confidence levels via \code{\link[=panel.qqmathci]{panel.qqmathci()}}.}

\item{...}{Parameters to pass on to \code{\link[lattice:qqmath]{lattice::qqmath()}}.}
}
\value{
Plots and returns a \code{trellis} object.
}
\description{
Draw quantile-Quantile plots of a sample against a theoretical distribution,
possibly conditioned on other variables.
}
\examples{
if (require(zoo))
  qqmath(zoo(lh))
}
\seealso{
\code{\link[lattice:qqmath]{lattice::qqmath()}}, \code{\link[zoo:zoo]{zoo::zoo()}}, \code{\link[lattice:panel.qqmathline]{lattice::panel.qqmathline()}}.
}
\author{
Original by Deepayan Sarkar.
}
