% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/test_diversity.R
\docType{methods}
\name{test_diversity}
\alias{test_diversity}
\alias{test_diversity-method}
\alias{test_diversity,CountMatrix-method}
\title{Diversity Test}
\usage{
test_diversity(object, ...)

\S4method{test_diversity}{CountMatrix}(object, adjust = "holm", ...)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} matrix of count data.}

\item{...}{Further arguments to be passed to internal methods.}

\item{adjust}{A \code{\link{character}} string specifying the method for
adjusting \eqn{p} values (see \code{\link[stats]{p.adjust}}).}
}
\value{
A \code{\link{numeric}} matrix.
}
\description{
Compares Shannon diversity between samples.
}
\details{
This test produces two sided pairwise comparisons: it returns a matrix of
 adjusted \eqn{p} values.
}
\examples{
## Shannon diversity test
data("merzbach", package = "folio")
merzbach_count <- as_count(merzbach)
div <- test_diversity(merzbach_count)
}
\references{
Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
 Princeton, NJ: Princeton University Press. \doi{10.1007/978-94-015-7358-0}.
}
\seealso{
Other statistics: 
\code{\link{independance}},
\code{\link{test_fit}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
