% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plotBar}
\alias{plotBar}
\alias{plotBar-method}
\alias{seriographe}
\alias{plotBar,CountMatrix-method}
\alias{plotBar,FrequencyMatrix-method}
\title{Bar plot}
\usage{
plotBar(object, ...)

\S4method{plotBar}{CountMatrix}(object, level = FALSE, EPPM = FALSE,
  center = TRUE, horizontal = FALSE)

\S4method{plotBar}{FrequencyMatrix}(object, level = FALSE,
  EPPM = FALSE, center = TRUE, horizontal = FALSE)
}
\arguments{
\item{object}{An object to be plotted.}

\item{...}{Further arguments passed to other methods.}

\item{level}{A length-one \code{\link{numeric}} vector giving the
confidence level to be drawn.}

\item{EPPM}{A \code{\link{logical}} scalar: should the EPPM be drawn (see
details)?}

\item{center}{A \code{\link{logical}} scalar: should the bar plot
be centered? The default, \code{TRUE}, produces a Ford diagram, otherwise it
produces a Bertin diagram.}

\item{horizontal}{A \code{\link{logical}} scalar: should the bar plot
be horizontal? The default, \code{FALSE}, means variables in rows and
cases in columns (i.e. Bertin diagram). Only used if \code{center} is
\code{FALSE}.}
}
\description{
Plots a Bertin or a Ford (battleship curve) diagram.
}
\details{
If \code{EPPM} is \code{TRUE} and if a relative abundance is greater than
 the mean percentage of the type, the exceeding part is highlighted.
 This positive difference from the column mean percentage (in french "écart
 positif au pourcentage moyen", EPPM) represents a deviation from the
 situation of statistical independence. As independence can be interpreted as
 the absence of relationships between types and the chronological order of
 the assemblages, \code{EPPM} is a usefull graphical tool to explore
 significance of relationship between rows and columns related to
 \code{\link[=seriate]{seriation}}.
}
\examples{
\donttest{

# Plot Ford diagram...
count <- as(compiegne, "CountMatrix") # Data from Desachy 2004
## ...without threshold
plotBar(count)
## ...with EPPM (i.e. Bruno Desachy's sériographe)
plotBar(count, EPPM = TRUE)

# Plot Bertin diagram...
freq <- as(boves, "FrequencyMatrix") # Data from Desachy 2004
## ...without EPPM...
plotBar(freq, center = FALSE, horizontal = TRUE)
## ...and confidence intervals
plotBar(freq, level = 0.05, center = FALSE, horizontal = FALSE)
## ...with EPPM (i.e. Bruno Desachy's sériographe)
plotBar(freq, EPPM = TRUE, center = FALSE, horizontal = TRUE)
}
}
\references{
Bertin, J. (1977). \emph{La graphique et le traitement graphique de
 l'information}. Paris: Flammarion. Nouvelle Bibliothèque Scientifique.

 Desachy, B. (2004). Le sériographe EPPM: un outil informatisé de sériation
 graphique pour tableaux de comptages. \emph{Revue archéologique de
 Picardie}, 3(1), 39-56.
 DOI: \href{https://doi.org/10.3406/pica.2004.2396}{10.3406/pica.2004.2396}.

 Ford, J. A. (1962). \emph{A quantitative method for deriving cultural
 chronology}. Washington, DC: Pan American Union. Technical manual 1.
}
\seealso{
Other plot: \code{\link{plotDate}},
  \code{\link{plotMatrix}}, \code{\link{plotRank}},
  \code{\link{plotSpot}}
}
\author{
N. Frerebeau
}
\concept{plot}
