% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notes.R
\name{valid-notes}
\alias{valid-notes}
\alias{is_note}
\alias{is_chord}
\alias{noteworthy}
\alias{is_diatonic}
\alias{as_noteworthy}
\title{Check note and chord validity}
\usage{
is_note(x)

is_chord(x)

noteworthy(x)

is_diatonic(x, key = "c")

as_noteworthy(x)
}
\arguments{
\item{x}{character, space-delimited entries or a vector of single, non-delimited entries.}

\item{key}{character, key signature.}
}
\value{
logical
}
\description{
Check whether a string is comprised exclusively of valid note and/or chord substring syntax.
\code{is_note} and \code{is_chord} are vectorized and their positive results are mutually exclusive.
\code{noteworthy} is also vectorized and performs both checks, but it returns a scalar logical result indicating whether the entire set contains exclusively valid entries.
}
\details{
\code{as_noteworthy} can be used to coerce to the \code{noteworthy} class. Coercion will fail if the string is not noteworthy.
Using the \code{noteworthy} class is generally not needed by the user during an interactive session, but is available and offers its own \code{print} and \code{summary} methods for noteworthy strings.
It is more likely to be used by other functions and functions that output a noteworthy string generally attach the noteworthy class.

\code{is_diatonic} performs a vectorized logical check on a \code{noteworthy} string for all notes and chords.
To check strictly notes or chords, see \code{\link{note_in_scale}} and \code{\link{chord_is_diatonic}}.
}
\examples{
x <- "a# b_ c, d'' e3 g_4 A m c2e_2g2 cegh"
data.frame(
  x = strsplit(x, " ")[[1]],
  note = is_note(x),
  chord = is_chord(x),
  either = noteworthy(x))

is_diatonic("ace ac#e d e_", "c")

x <- "a# b_ c,~ c, d'' e3 g_4 c2e_2g2"
x <- as_noteworthy(x)
x

summary(x)
}
\seealso{
\code{\link{note_in_scale}}, \code{\link{chord_is_diatonic}}
}
