% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datetime2fac.R
\name{datetime2fac}
\alias{datetime2fac}
\title{Transform a date-time vector to a factor}
\usage{
datetime2fac(p, rng = range(p, na.rm = TRUE))
}
\arguments{
\item{p}{date-time vector}

\item{rng}{range of the factor.}
}
\value{
A factor vector.
}
\description{
Transform a date-time vector from class \code{\link{POSIXt}} or \code{\link{Date}} to a factor.
}
\details{
The range \code{rng} is cut according to different pretty rounded time periods. The cut with the number of levels that is closest to 6 is chosen. Vector \code{p} is cut accordingly. Values of \code{p} outside \code{rng} are translated to \code{NA}.
}
\note{
This function is still in development stage, and can be improved and optimized. \code{ff} vectors are not implemented yet
}
\examples{
d <- as.Date("2012-12-21") + sample.int(500, 1000, replace=TRUE)
d2 <- datetime2fac(d)
levels(d2)

t <- as.POSIXlt(Sys.time(), "GMT") + sample.int(1e5, 1000, replace=TRUE)
t2 <- datetime2fac(t)
levels(t2)
}
\seealso{
\code{\link{num2fac}}
}
