% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesa.R
\name{mesa}
\alias{mesa}
\title{Drag-and-drop Descriptive Statistics}
\usage{
mesa(launch.browser = TRUE, display.mode = "normal", ...)
}
\arguments{
\item{launch.browser}{passed to \code{\link[shiny]{runApp}}}

\item{display.mode}{passed to \code{\link[shiny]{runApp}}}

\item{...}{passed to \code{\link[shiny]{runApp}}}
}
\value{
used for side effects: launches shiny application
}
\description{
Generate a table of descriptive statistics
by selecting columns from a file.
Currently supported formats include *.xpt, *.sas7bdat, and *.csv.
Launch the application using \code{mesa()} and use the interface
to select a data file, such as 'mtcars.xpt' under 'examples/')
(or select configuration file 'mtcars.conf' under 'examples/').
Then classify the
columns of interest to generate the corresponding
displays.
}
\details{
Currently,

* xpt files are read using the defaults for \code{\link[foreign]{read.xport}},

* sas7bdat files are read using the defaults for \code{\link[haven]{read_sas}}, and

* csv files are read using the defaults for \code{\link[csv]{as.csv}}.

If a file in the same directory has a corresponding base name but a \code{.yaml}
extension, it is treated as metadata and an attempt is made to apply it
to the internal version of the data. This file will not be over-written,
but it WILL be constructed if missing.  You can hand-edit it to supply
metadata.  See \code{?yamlet} for format; see the Metadata tab for an easy interface.

This is a metadata-driven application.  Columns in the data that are *not*
in the metadata will be ignored, and columns in the metadata that are *not*
in the data will be constructed (maybe *all* of them).

The \code{\link[datasets]{mtcars}} datasets in the 'examples' volume is from \pkg{datasets}.
}
