% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-transmute.R
\name{transmute-table.express}
\alias{transmute-table.express}
\alias{transmute.ExprBuilder}
\title{Compute new columns}
\usage{
\method{transmute}{ExprBuilder}(.data, ...,
  .parse = getOption("table.express.parse", FALSE),
  .chain = getOption("table.express.chain", TRUE))
}
\arguments{
\item{.data}{An instance of \link{ExprBuilder}.}

\item{...}{Clauses for transmuting columns. For \code{j} inside the \code{data.table}'s frame.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}

\item{.chain}{Logical. Should a new frame be automatically chained to the expression if the
clause being set already exists?}
}
\description{
Compute and keep only new columns.
}
\details{
Everything in \code{...} is wrapped in a call to \code{list}.

To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
\examples{

data("mtcars")

data.table::as.data.table(mtcars) \%>\%
    start_expr \%>\%
    transmute(ans = mpg * 2)

}
