% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jagsTwoBaselinesFull.R
\name{jagsTwoBaselinesFull}
\alias{jagsTwoBaselinesFull}
\title{Defines a jags Bayesian model to fit a two baselines trophic position full
model (with fractionation for C)}
\usage{
jagsTwoBaselinesFull(sigmaNc = NULL, sigmaCc = NULL, muCb1 = NULL,
  sigmaCb1 = NULL, muNb1 = NULL, sigmaNb1 = NULL, muCb2 = NULL,
  sigmaCb2 = NULL, muNb2 = NULL, sigmaNb2 = NULL, lambda = NULL,
  TP = NULL, alpha = NULL, muDeltaN = NULL, sigmaDeltaN = NULL,
  muDeltaC = NULL, sigmaDeltaC = NULL, ...)
}
\arguments{
\item{sigmaNc}{a distribution defining sigma (standard deviation) for N of
consumer. Default is dunif(0, 100).}

\item{sigmaCc}{a distribution defining sigma (standard deviation) for C of
consumer. Default is dunif(0, 100).}

\item{muCb1}{a distribution defining prior for mean (mu) for C of baseline 1.
Default is dnorm(0, 0.0001).}

\item{sigmaCb1}{a distribution defining sigma (standard deviation) for C of
baseline 1. Default is dunif(0, 100).}

\item{muNb1}{a distribution defining prior for mean (mu) for N of baseline 1.
dnorm(0, 0.0001)}

\item{sigmaNb1}{a distribution defining sigma (standard deviation) for N of
baseline 1. Default is dunif(0, 100).}

\item{muCb2}{a distribution defining prior for mean (mu) for C of baseline 2.
dnorm(0, 0.0001)}

\item{sigmaCb2}{a distribution defining sigma (standard deviation) for C of
baseline 2. Default is dunif(0, 100).}

\item{muNb2}{a distribution defining prior for mean (mu) for N of baseline 2.
dnorm(0, 0.0001)}

\item{sigmaNb2}{a distribution defining sigma (standard deviation) for N of
baseline 2. Default is dunif(0, 100).}

\item{lambda}{an integer indicating the trophic position of the baseline.
Default is 2.}

\item{TP}{a distribution defining prior of trophic position. Default is
dunif(lambda, 10), with lambda defined above.}

\item{alpha}{a distribution defining alpha (mixing model between 2 sources).
Default is dbeta(1,1).}

\item{muDeltaN}{a distribution defining prior for the mean (mu) of deltaN,
which stands for trophic discrimination factor of Nitrogen. Default is
dnorm(0, 0.0001).}

\item{sigmaDeltaN}{a value defining sigma (standard deviation) for the mean
(mu) of deltaN. Default is dunif(0, 100).}

\item{muDeltaC}{a distribution defining prior for the mean (mu) of deltaC,
which stands for trophic discrimination factor of Carbon}

\item{sigmaDeltaC}{a value defining sigma (standard deviation) for the mean
(mu) of deltaC.}

\item{...}{additional arguments passed to this function.}
}
\value{
A jags model as a character string
}
\description{
Takes some parameters and returns a jags model object as a character string
for passing to \code{\link[rjags]{jags.model}}.
}
\details{
The two baselines trophic position full model is defined as:

\deqn{dNc ~ dnorm(deltaN * (TP - lambda) + dNb1*alpha + dNb2 * (1 - alpha),
tauNc)} and \deqn{dCc ~ dnorm(dCb2 + (deltaC * (TP-lambda)) + (alpha * (dCb1
- dCb2)), tauCc))}

where dNc and dCc are d15N and d13C values of consumer, dNb1 and dCb1 are
d15N and d13C values of baseline 1, dNb2 and dCb2 are d15N and d13C values of
baseline 2, alpha is the relative proportion of N derived from baseline 1,
deltaN is the trophic discrimination factor for N, deltaC is the trophic
discrimination factor for C, TP is trophic position of the consumer and
lambda is the trophic level of baselines.

In this Bayesian model, both dNc and dCc are modelled as having a normal
distribution with means calculated with above equations and precision (tauNc
and tauCc) calculated as standard deviation ^-2. Furthermore, dNb1, dCb1,
dNb2, dCb2, deltaN and deltaC are defined as random parameters with a normal
distribution with mean mu_i and precision tau_i, TP is a random parameter
with a uniform distribution, alpha is a random parameter with a beta
distribution and lambda is a constant. All these distributions can be changed
modifying them as priors, while defining lambda within the call to the
function.

You might want to change the mean, standard deviation or other parameters of
the distributions according to your prior knowledge of the system/consumer
you are working on. Although it is possible to use a number of predefined or
customized distributions (see distribution aliases in
\href{https://sourceforge.net/projects/mcmc-jags/files/Manuals/}{JAGS
documentation}), it is likely that most of the time you will be using a
normal distribution as prior for most parameters. This is the default option
(i.e. when the function is called without arguments). To change it, you need
to indicate a mean and standard deviation for the i-est parameter of
interest, for example "dnorm(0, 0.0001)". Here, a prior of normally
distributed mu_i is defined, with a mean 0, and a standard deviation of
0.0001. This constitutes an uninformative and normally distributed prior, for
the mean of the i-est parameter.  As well as the priors for mu_i, JAGS uses
"tau", which is the precision for defining the standard deviation of mu_i.
Precision is a deterministic function (instead of the distributional "~"),
and it is calculated as "tau_i <- power(sigma_i, -2)", thus you could define
as well sigma_i, which stands for the standard deviation of the i-est
parameter of interest. In the case of alpha, the default is a beta
distribution with parameters a = 1 and b = 1.
}
