% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.search.R
\name{trakt.search}
\alias{trakt.search}
\title{Search for a show via text query}
\usage{
trakt.search(query, type = "show", year = NULL)
}
\arguments{
\item{query}{The keyword used for the search. If the query ends with a 4 digit numbers,
this will be used as \code{year} parameter.}

\item{type}{The type of data you're looking for. Defaults to \code{show}, can also be
\code{movie}, \code{episode}, \code{person} or \code{list}.}

\item{year}{Optionally filter by year.}
}
\value{
A \code{data.frame} containing a single search result. Hopefully the one you wanted. If
  no result is found, the return value is \code{list(error = "Nothing found")} and a
  \code{warning}
}
\description{
\code{trakt.search} returns search result info.
}
\details{
Search for a show or movie with a keyword (e.g. \code{"Breaking Bad"}) and receive basic info of the first
search result. It's main use is to retrieve the ids or proper show/movie title for further use, as well
as receiving a quick overview of a show/movie.
}
\note{
See \href{http://docs.trakt.apiary.io/reference/search/text-query}{the trakt API docs for
  further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
breakingbad <- trakt.search("Breaking Bad")
}
}
\seealso{
Other API-basics: \code{\link{get_trakt_credentials}};
  \code{\link{trakt.api.call}};
  \code{\link{trakt.search.byid}}

Other search functions: \code{\link{trakt.search.byid}}
}

