% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_Network_Evaluations.R
\name{default_cascade}
\alias{default_cascade}
\title{Default Cascade}
\usage{
default_cascade(L, ea, el = 0, recoveryrate = 0)
}
\arguments{
\item{L}{liability matrix}

\item{ea}{vector of external assets}

\item{el}{vector of external liabilites (default 0)}

\item{recoveryrate}{recovery rate in [0,1] (defaults to 0)}
}
\value{
vector indicating which banks default (1=default, 0= no default)
}
\description{
Computes bank defaults via the default cascade algorithm.
}
\examples{
ea <- c(1/2,5/8,3/4)
el <- c(3/2,1/2,1/2)
x <- 0.5
L <- matrix(c(0,x,1-x,1-x,0,x,x,1-x,0),nrow=3)
default_cascade(L,ea,el)
}

