% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_inc_earnings.R
\name{pull_inc_earnings}
\alias{pull_inc_earnings}
\title{Pull ACS income and earnings data}
\usage{
pull_inc_earnings(endyear, span, geography)
}
\arguments{
\item{endyear}{An integer, indicating the latest year of the data in the survey.}

\item{span}{An integer in \code{c(1,3,5)} indicating the span of the desired data.}

\item{geography}{a valid \code{geo.set} object specifying the census geography or 
geographies to be fetched.}
}
\value{
A \code{list} containing the endyear, span, a \code{data.frame} of estimates,
a \code{data.frame} of standard errors, a character vector of the original column names,
and a \code{data.frame} of the geography metadata from \code{\link[acs]{acs.fetch}}.
}
\description{
Pull ACS data for a specified geography from base tables
B19083, B19301, B19326, B21001, B22001, B23020, B24011. Not yet 
implemented: B28004
Additional fields, mainly percentages and aggregations, are calculated.
}
\seealso{
\code{\link[acs]{acs.fetch}}, \code{\link[acs]{geo.make}}
}

