/*
 * Decompiled with CFR 0.152.
 */
package main;

import blbutil.Const;
import blbutil.IntPair;
import dag.Dag;
import dag.MergeableDag;
import haplotype.BasicHapPairs;
import haplotype.BasicSampleHapPairs;
import haplotype.ConsensusPhaser;
import haplotype.GLSampleHapPairs;
import haplotype.GenotypeCorrection;
import haplotype.HapPair;
import haplotype.HapPairs;
import haplotype.SampleHapPairs;
import haplotype.WrappedHapPair;
import ibd.HaploidIbd;
import ibd.IbdSegment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import main.AlleleProbs;
import main.BasicAlleleProbs;
import main.CurrentData;
import main.GeneticMap;
import main.GenotypeValues;
import main.HapPairSampler;
import main.LiAndStephensHapSampler;
import main.Par;
import main.PositionMap;
import main.RecombHapPairSampler;
import main.RunStats;
import main.SampleHapPairAlleleProbs;
import vcf.MaskedEndsGL;
import vcf.NoPhaseGL;

public class MainHelper {
    private final Par par;
    private final HapPairSampler hapSampler;
    private final RecombHapPairSampler recombSampler;
    private final GeneticMap genMap;
    private final RunStats runStats;

    MainHelper(Par par, GeneticMap geneticMap, RunStats runStats) {
        if (runStats == null) {
            throw new NullPointerException("runStats==null");
        }
        if (geneticMap == null) {
            double d = 1.0E-6;
            geneticMap = new PositionMap(d);
        }
        this.par = par;
        this.hapSampler = new HapPairSampler(par, runStats);
        this.recombSampler = new RecombHapPairSampler(par, runStats);
        this.genMap = geneticMap;
        this.runStats = runStats;
    }

    SampleHapPairs phase(CurrentData currentData, GenotypeValues genotypeValues) {
        this.checkParameters(currentData, genotypeValues);
        if (currentData.targetGL().isRefData()) {
            return new GLSampleHapPairs(currentData.targetGL());
        }
        List<HapPair> list = this.hapSampler.initialHaps(currentData);
        if (this.par.burnin_its() > 0) {
            this.runStats.println(Const.nl + "Starting burn-in iterations");
            list = this.runBurnin1(currentData, list);
        }
        if (this.par.phase_its() > 0) {
            boolean bl = this.par.gt() == null && this.par.niterations() == 0;
            list = this.runBurnin2(currentData, list, bl ? genotypeValues : null);
        }
        if (this.par.niterations() > 0) {
            this.runStats.println(Const.nl + "Starting phasing iterations");
            list = this.runRecomb(currentData, list, genotypeValues);
        } else {
            list = ConsensusPhaser.run(list);
        }
        return new BasicSampleHapPairs(currentData.targetSamples(), list);
    }

    private void checkParameters(CurrentData currentData, GenotypeValues genotypeValues) {
        if (genotypeValues != null && !genotypeValues.markers().equals(currentData.targetMarkers())) {
            throw new IllegalArgumentException(String.valueOf(genotypeValues));
        }
        if (genotypeValues != null && !genotypeValues.samples().equals(currentData.targetSamples())) {
            throw new IllegalArgumentException(String.valueOf(genotypeValues));
        }
    }

    private List<HapPair> runBurnin1(CurrentData currentData, List<HapPair> list) {
        GenotypeValues genotypeValues = null;
        for (int i = 0; i < this.par.burnin_its(); ++i) {
            boolean bl = (i & 1) == 1;
            list = this.hapSampler.sample(currentData, list, bl, genotypeValues);
            this.runStats.printIterationUpdate(currentData.window(), i + 1);
        }
        return list;
    }

    private List<HapPair> runBurnin2(CurrentData currentData, List<HapPair> list, GenotypeValues genotypeValues) {
        ArrayList<HapPair> arrayList = new ArrayList<HapPair>();
        int n = this.par.burnin_its();
        int n2 = n + this.par.phase_its();
        for (int i = n; i < n2; ++i) {
            boolean bl = (i & 1) == 1;
            list = this.hapSampler.sample(currentData, list, bl, genotypeValues);
            this.runStats.printIterationUpdate(currentData.window(), i + 1);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private List<HapPair> runRecomb(CurrentData currentData, List<HapPair> list, GenotypeValues genotypeValues) {
        list = ConsensusPhaser.run(list);
        ArrayList<HapPair> arrayList = new ArrayList<HapPair>();
        int n = this.par.burnin_its() + this.par.phase_its();
        int n2 = n + this.par.niterations();
        for (int i = n; i < n2; ++i) {
            boolean bl = (i & 1) == 1;
            list = this.recombSampler.sample(currentData, list, bl, genotypeValues);
            this.runStats.printIterationUpdate(currentData.window(), i + 1);
            arrayList.addAll(list);
        }
        list = ConsensusPhaser.run(arrayList);
        list = this.correctGenotypes(currentData, list);
        return list;
    }

    private List<HapPair> correctGenotypes(CurrentData currentData, List<HapPair> list) {
        int n = currentData.prevTargetSpliceStart();
        int n2 = currentData.nextTargetSpliceStart();
        MaskedEndsGL maskedEndsGL = new MaskedEndsGL(currentData.targetGL(), n, n2);
        GenotypeCorrection.run(list, maskedEndsGL, this.par.seed());
        return list;
    }

    Map<IntPair, List<IbdSegment>> refinedIbd(CurrentData currentData, SampleHapPairs sampleHapPairs) {
        if (this.par.ibd()) {
            long l = System.nanoTime();
            int n = currentData.nRefSamples() + currentData.nTargetSamples();
            float f = this.par.adjustedIbdScale(n);
            Dag dag = this.ibdDag(currentData, sampleHapPairs, f);
            HaploidIbd haploidIbd = new HaploidIbd(this.genMap, this.par.ibdtrim(), this.par.ibdlod(), this.par.ibdcm());
            NoPhaseGL noPhaseGL = new NoPhaseGL(currentData.targetGL());
            Map<IntPair, List<IbdSegment>> map = haploidIbd.run(noPhaseGL, dag, sampleHapPairs, this.par.nthreads());
            long l2 = System.nanoTime() - l;
            this.runStats.ibdNanos(l2);
            this.runStats.printRefinedIbdUpdate(f, dag, l2);
            return map;
        }
        return null;
    }

    private Dag ibdDag(CurrentData currentData, SampleHapPairs sampleHapPairs, float f) {
        int n;
        float[] fArray;
        HapPairs hapPairs;
        float[] fArray2 = currentData.weights().get(sampleHapPairs);
        if (currentData.nRefSamples() == 0) {
            hapPairs = sampleHapPairs;
            fArray = fArray2;
        } else {
            int n2;
            ArrayList<HapPair> arrayList = new ArrayList<HapPair>(currentData.nAllSamples());
            currentData.addRestrictedRefHapPairs(arrayList);
            n = sampleHapPairs.nSamples();
            for (n2 = 0; n2 < n; ++n2) {
                arrayList.add(new WrappedHapPair(sampleHapPairs, n2));
            }
            hapPairs = new BasicHapPairs(arrayList);
            n2 = 2 * currentData.nRefSamples();
            fArray = new float[hapPairs.nHaps()];
            Arrays.fill(fArray, 0, n2, 1.0f);
            System.arraycopy(fArray2, 0, fArray, n2, fArray2.length);
        }
        long l = System.nanoTime();
        n = 500;
        Dag dag = MergeableDag.dag(hapPairs, fArray, f, n);
        this.runStats.buildNanos(System.nanoTime() - l);
        this.runStats.setDagStats(dag);
        return dag;
    }

    AlleleProbs LSImpute(CurrentData currentData, SampleHapPairs sampleHapPairs) {
        if (currentData.nMarkers() == currentData.nTargetMarkers() || !this.par.impute()) {
            return new SampleHapPairAlleleProbs(sampleHapPairs);
        }
        long l = System.nanoTime();
        LiAndStephensHapSampler liAndStephensHapSampler = new LiAndStephensHapSampler(this.par, this.genMap);
        BasicAlleleProbs basicAlleleProbs = liAndStephensHapSampler.sample(currentData, sampleHapPairs);
        this.runStats.imputationNanos(System.nanoTime() - l);
        this.runStats.printImputationUpdate();
        return basicAlleleProbs;
    }
}

