/*
 * Decompiled with CFR 0.152.
 */
package beagleutil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Ids {
    public static final int DEFAULT_INIT_CAPACITY = 5000;
    private final List<String> idList;
    private final Map<String, Integer> idMap;

    public Ids() {
        this(5000);
    }

    public Ids(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("initCapacity: " + n);
        }
        this.idList = new ArrayList<String>(n);
        this.idMap = new HashMap<String, Integer>(n);
    }

    public synchronized int indexOf(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("id.isEmpty()==true");
        }
        if (this.idMap.keySet().contains(string)) {
            return this.idMap.get(string);
        }
        int n = this.idList.size();
        this.idList.add(string);
        this.idMap.put(string, n);
        return n;
    }

    public synchronized int indexIfIndexed(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("id.isEmpty()==true");
        }
        if (this.idMap.keySet().contains(string)) {
            return this.idMap.get(string);
        }
        return -1;
    }

    public synchronized int size() {
        return this.idList.size();
    }

    public synchronized String id(int n) {
        return this.idList.get(n);
    }

    public synchronized String[] ids() {
        return this.idList.toArray(new String[0]);
    }

    public String toString() {
        return Arrays.toString(this.ids());
    }
}

