/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.ChromInterval;
import beagleutil.Samples;
import blbutil.Filter;
import blbutil.FilterUtils;
import blbutil.IntPair;
import blbutil.Utilities;
import haplotype.HapPair;
import haplotype.SampleHapPairs;
import haplotype.SampleHapPairsSplicer;
import haplotype.Weights;
import ibd.IbdSegment;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import main.BasicGenotypeValues;
import main.GeneticMap;
import main.GenotypeValues;
import main.Logger;
import main.MainHelper;
import main.NuclearFamilies;
import main.Parameters;
import main.RestrictedGenotypeValues;
import main.RunStats;
import main.WindowWriter;
import vcf.AllData;
import vcf.Data;
import vcf.GL;
import vcf.Marker;
import vcf.MarkerFilterUtils;
import vcf.Markers;
import vcf.NonRefData;
import vcf.VcfRecord;

public class Main {
    public static final String version = "beagle.jar (r1399)";
    public static final String copyright = "Copyright (C) 2014 Brian L. Browning";
    private final Parameters par;
    private final GeneticMap genMap;
    private final Data data;
    private final RunStats runStats;
    private final WindowWriter windowOut;

    public static void main(String[] stringArray) {
        Locale.setDefault(Locale.US);
        if (stringArray.length == 0) {
            System.out.println(version);
            System.out.println(copyright);
            System.out.println(Parameters.usage());
            System.exit(0);
        }
        Parameters parameters = Main.parameters(stringArray);
        Main.setLoggingTarget(parameters.out());
        RunStats runStats = new RunStats(parameters);
        runStats.printStartInfo();
        Data data = parameters.ref() == null ? Main.nonRefData(parameters) : Main.allData(parameters);
        GeneticMap geneticMap = Main.geneticMap(parameters);
        WindowWriter windowWriter = new WindowWriter(data.nonRefSamples(), parameters.out());
        Main main = new Main(parameters, data, geneticMap, windowWriter, runStats);
        main.phaseData();
        data.close();
        windowWriter.close();
        Main.closeLogger(parameters.out(), runStats);
        runStats.printSummaryAndClose(data.cumMarkerCnt());
    }

    private Main(Parameters parameters, Data data, GeneticMap geneticMap, WindowWriter windowWriter, RunStats runStats) {
        assert (parameters != null);
        assert (data != null);
        assert (windowWriter != null);
        assert (runStats != null);
        this.par = parameters;
        this.genMap = geneticMap;
        this.data = data;
        this.runStats = runStats;
        this.windowOut = windowWriter;
    }

    private void phaseData() {
        NuclearFamilies nuclearFamilies = new NuclearFamilies(this.data.nonRefSamples(), this.par.ped());
        Weights weights = new Weights(nuclearFamilies);
        this.runStats.printSampleSummary(nuclearFamilies, this.data);
        SampleHapPairs sampleHapPairs = null;
        Random random = new Random(this.par.seed());
        MainHelper mainHelper = new MainHelper(this.par, this.genMap, nuclearFamilies, weights, this.runStats, random);
        while (this.data.canAdvanceWindow()) {
            this.advanceWindow();
            int n = this.data.overlap() / 2;
            int n2 = Main.nextOverlap(this.data, this.par.overlap());
            int n3 = Main.nextSplice(this.data, this.par.overlap());
            Markers markers = this.data.markers();
            List<HapPair> list = this.data.restrictedRefHaps();
            GL gL = this.data.nonRefEmissions();
            GenotypeValues genotypeValues = this.gv(markers, gL.samples());
            GenotypeValues genotypeValues2 = this.restrictAndInitializeGV(genotypeValues, gL);
            SampleHapPairs sampleHapPairs2 = mainHelper.sample(this.data, genotypeValues2);
            if (sampleHapPairs != null) {
                int n4 = this.targetIndex(n);
                sampleHapPairs2 = SampleHapPairsSplicer.spliceNext(sampleHapPairs, sampleHapPairs2, n4, this.data.nonRefOverlap());
            }
            Map<IntPair, List<IbdSegment>> map = mainHelper.refinedIbd(list, gL, sampleHapPairs2, weights);
            sampleHapPairs = sampleHapPairs2;
            SampleHapPairs sampleHapPairs3 = mainHelper.impute(this.data, sampleHapPairs2, genotypeValues);
            this.windowOut.print(sampleHapPairs3, genotypeValues, map, n, n2, n3);
        }
    }

    static int nextOverlap(Data data, int n) {
        if (data.canAdvanceWindow() && !data.lastWindowOnChrom()) {
            return data.nMarkers() - n;
        }
        return data.nMarkers();
    }

    static int nextSplice(Data data, int n) {
        if (data.canAdvanceWindow() && !data.lastWindowOnChrom()) {
            return data.nMarkers() - n + n / 2;
        }
        return data.nMarkers();
    }

    private GenotypeValues gv(Markers markers, Samples samples) {
        BasicGenotypeValues basicGenotypeValues = null;
        if (this.par.gprobs()) {
            basicGenotypeValues = new BasicGenotypeValues(markers, samples);
        }
        return basicGenotypeValues;
    }

    private int targetIndex(int n) {
        int n2;
        for (n2 = 0; n2 < this.data.nNonRefMarkers() && this.data.markerIndex(n2) < n; ++n2) {
        }
        return n2;
    }

    private GenotypeValues restrictAndInitializeGV(GenotypeValues genotypeValues, GL gL) {
        if (!this.par.gprobs()) {
            return genotypeValues;
        }
        RestrictedGenotypeValues restrictedGenotypeValues = new RestrictedGenotypeValues(genotypeValues, gL.markers());
        if (this.par.gprobs()) {
            int n = gL.nMarkers();
            int n2 = gL.nSamples();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    byte by = gL.allele1(i, j);
                    byte by2 = gL.allele2(i, j);
                    if (by < 0 || by2 < 0) continue;
                    int n3 = VcfRecord.gtIndex(by, by2);
                    restrictedGenotypeValues.add(i, j, n3, 1.0);
                }
            }
        }
        return restrictedGenotypeValues;
    }

    private static void setLoggingTarget(String string) {
        File file = new File(string + ".warnings");
        Logger.getInstance().setTarget(file);
    }

    private static void closeLogger(String string, RunStats runStats) {
        if (Logger.getInstance().logCnt() > 0) {
            String string2 = "Warnings printed: see " + string + ".warnings file";
            runStats.println(string2);
        }
        Logger.getInstance().close();
    }

    private static Filter<Marker> markerFilter(Parameters parameters) {
        Filter<Marker> filter = null;
        if (parameters.excludemarkers() != null) {
            Set<String> set = Utilities.idSet(parameters.excludemarkers());
            filter = MarkerFilterUtils.excludeIdFilter(set);
        }
        return filter;
    }

    private static Filter<String> sampleFilter(Parameters parameters) {
        Filter<String> filter = null;
        if (parameters.excludesamples() != null) {
            Set<String> set = Utilities.idSet(parameters.excludesamples());
            filter = FilterUtils.excludeFilter(set);
        }
        return filter;
    }

    private static ChromInterval chromInterval(Parameters parameters) {
        ChromInterval chromInterval = null;
        if (parameters.chrom() != null) {
            chromInterval = ChromInterval.parse(parameters.chrom());
        }
        return chromInterval;
    }

    private static Data nonRefData(Parameters parameters) {
        Filter<String> filter = Main.sampleFilter(parameters);
        Filter<Marker> filter2 = Main.markerFilter(parameters);
        ChromInterval chromInterval = Main.chromInterval(parameters);
        if (parameters.gt() != null) {
            assert (parameters.gl() == null && parameters.gtgl() == null);
            return NonRefData.gt(parameters.gt(), filter, filter2, chromInterval, parameters.ped(), parameters.usephase());
        }
        if (parameters.gl() != null) {
            assert (parameters.gt() == null && parameters.gtgl() == null);
            return NonRefData.gl(parameters.gl(), filter, filter2, chromInterval, parameters.ped(), parameters.maxlr());
        }
        assert (parameters.gt() == null && parameters.gl() == null);
        return NonRefData.gtgl(parameters.gtgl(), parameters.ped(), parameters.usephase(), parameters.maxlr(), filter, filter2, chromInterval);
    }

    private static Data allData(Parameters parameters) {
        Filter<String> filter = Main.sampleFilter(parameters);
        Filter<Marker> filter2 = Main.markerFilter(parameters);
        ChromInterval chromInterval = Main.chromInterval(parameters);
        if (parameters.gt() != null) {
            assert (parameters.gl() == null && parameters.gtgl() == null);
            return AllData.gt(parameters.ref(), parameters.gt(), filter, filter2, chromInterval, parameters.ped(), parameters.usephase(), parameters.impute());
        }
        if (parameters.gl() != null) {
            assert (parameters.gt() == null && parameters.gtgl() == null);
            return AllData.gl(parameters.ref(), parameters.gl(), filter, filter2, chromInterval, parameters.ped(), parameters.maxlr(), parameters.impute());
        }
        assert (parameters.gt() == null && parameters.gl() == null && parameters.gtgl() != null);
        return AllData.gtgl(parameters.ref(), parameters.gtgl(), filter, filter2, chromInterval, parameters.ped(), parameters.usephase(), parameters.maxlr(), parameters.impute());
    }

    private static GeneticMap geneticMap(Parameters parameters) {
        if (parameters.map() == null) {
            return null;
        }
        String string = Main.extractChrom(parameters.chrom());
        if (string == null) {
            return GeneticMap.fromPlinkMapFile(parameters.map());
        }
        return GeneticMap.fromPlinkMapFile(parameters.map(), string);
    }

    private static String extractChrom(String string) {
        if (string != null && string.length() > 0) {
            int n = string.indexOf(58);
            if (n == -1) {
                return string;
            }
            return new String(string.substring(0, n));
        }
        return null;
    }

    private static Parameters parameters(String[] stringArray) {
        String string;
        Parameters parameters = new Parameters(stringArray);
        Main.checkForOneInputFile(parameters);
        Main.checkOutputPrefix(parameters);
        if (parameters.overlap() >= parameters.window()) {
            string = "ERROR: \"overlap\" parameter (" + parameters.overlap() + " must less than \"windowsize\" parameter (" + parameters.window() + ")";
            Utilities.exit(Parameters.usage() + string);
        }
        if (parameters.chrom() != null && ChromInterval.parse(parameters.chrom()) == null) {
            string = "ERROR: invalid \"chrom\" parameter: \"" + parameters.chrom() + "\"";
            Utilities.exit(Parameters.usage() + string);
        }
        if (parameters.ibd() && parameters.ref() != null && parameters.impute()) {
            string = "ERROR: The \"impute=false\" parameter is required when a reference panel is specified and \"ibd=true\"";
            Utilities.exit(Parameters.usage() + string);
        }
        if (parameters.burnin_its() == 0 && parameters.phase_its() == 0 && parameters.ped() != null) {
            string = "ERROR: The \"ped\" parameter cannot be used when thereare no burnin or phasing iterations (\"burnin-its=0 phase-its=0\")";
            Utilities.exit(Parameters.usage() + string);
        }
        return parameters;
    }

    private static void checkForOneInputFile(Parameters parameters) {
        int n = 0;
        if (parameters.gt() != null) {
            ++n;
        }
        if (parameters.gl() != null) {
            ++n;
        }
        if (parameters.gtgl() != null) {
            ++n;
        }
        if (n != 1) {
            String string = "ERROR: exactly one \"gt\", \"gl\" or \"gtgl\" parameter is required.";
            Utilities.exit(Parameters.usage() + string);
        }
    }

    private static void checkOutputPrefix(Parameters parameters) {
        String string;
        Object object;
        File file = new File(parameters.out());
        if (file.isDirectory()) {
            object = "ERROR: \"out\" parameter cannot be a directory: \"" + parameters.out() + "\"";
            Utilities.exit(Parameters.usage() + (String)object);
        }
        if (((File)(object = new File(parameters.out() + ".vcf.gz"))).equals(parameters.ref())) {
            string = "ERROR: VCF output file equals input file: " + parameters.ref();
            Utilities.exit(Parameters.usage() + string);
        }
        if (((File)object).equals(parameters.gt())) {
            string = "ERROR: VCF output file equals input file: " + parameters.gt();
            Utilities.exit(Parameters.usage() + string);
        }
        if (((File)object).equals(parameters.gl())) {
            string = "ERROR: VCF output file equals input file: " + parameters.gl();
            Utilities.exit(Parameters.usage() + string);
        }
        if (((File)object).equals(parameters.gtgl())) {
            string = "ERROR: VCF output file equals input file: " + parameters.gtgl();
            Utilities.exit(Parameters.usage() + string);
        }
    }

    private void advanceWindow() {
        if (this.data.canAdvanceWindow()) {
            this.data.advanceWindow(this.par.overlap(), this.par.window());
        }
        this.runStats.printWindowUpdate(this.data);
    }
}

