/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Random;
import main.GenotypeValues;
import vcf.Marker;

public class GprobsStatistics {
    private static final Random random = new Random(123L);
    private static final DecimalFormat df = new DecimalFormat("0.####");
    private final Marker marker;
    private final int nSamples;
    private final float[] alleleFreq;
    private float sumCall = 0.0f;
    private float sumSquareCall = 0.0f;
    private float sumExpected = 0.0f;
    private float sumExpectedSquare = 0.0f;
    private float sumSquareExpected = 0.0f;
    private float sumCallExpected = 0.0f;

    public GprobsStatistics(GenotypeValues genotypeValues, int n) {
        int n2 = genotypeValues.marker(n).nAlleles();
        this.marker = genotypeValues.marker(n);
        this.nSamples = genotypeValues.nSamples();
        this.alleleFreq = new float[n2];
        float[] fArray = new float[3];
        for (int i = 0; i < this.nSamples; ++i) {
            GprobsStatistics.setProbs(genotypeValues, n, i, fArray, this.alleleFreq);
            int n3 = GprobsStatistics.maxIndex(fArray, random);
            float f = fArray[1] + 2.0f * fArray[2];
            float f2 = fArray[1] + 4.0f * fArray[2];
            this.sumCall += (float)n3;
            this.sumSquareCall += (float)(n3 * n3);
            this.sumExpected += f;
            this.sumExpectedSquare += f2;
            this.sumSquareExpected += f * f;
            this.sumCallExpected += (float)n3 * f;
        }
        GprobsStatistics.divideBySum(this.alleleFreq);
    }

    private static void setProbs(GenotypeValues genotypeValues, int n, int n2, float[] fArray, float[] fArray2) {
        int n3;
        Arrays.fill(fArray, 0.0f);
        int n4 = genotypeValues.marker(n).nGenotypes();
        float f = 0.0f;
        for (n3 = 0; n3 < n4; ++n3) {
            f += genotypeValues.value(n, n2, n3);
        }
        n3 = -1;
        for (int i = 0; i < fArray2.length; ++i) {
            for (int j = 0; j < i; ++j) {
                float f2 = genotypeValues.value(n, n2, ++n3) / f;
                int n5 = j;
                fArray2[n5] = fArray2[n5] + f2;
                int n6 = i;
                fArray2[n6] = fArray2[n6] + f2;
                int n7 = j == 0 ? 1 : 2;
                fArray[n7] = fArray[n7] + f2;
            }
            float f3 = genotypeValues.value(n, n2, ++n3) / f;
            int n8 = i;
            fArray2[n8] = fArray2[n8] + 2.0f * f3;
            int n9 = i == 0 ? 0 : 2;
            fArray[n9] = fArray[n9] + f3;
        }
    }

    private static int maxIndex(float[] fArray, Random random) {
        int n;
        int n2;
        int n3 = n2 = random.nextInt(fArray.length);
        for (n = n2 + 1; n < fArray.length; ++n) {
            if (!(fArray[n] > fArray[n3])) continue;
            n3 = n;
        }
        for (n = 0; n < n2; ++n) {
            if (!(fArray[n] > fArray[n3])) continue;
            n3 = n;
        }
        return n3;
    }

    private static void divideBySum(float[] fArray) {
        float f = 0.0f;
        for (float f2 : fArray) {
            f += f2;
        }
        int n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = fArray[n2] / f;
        }
    }

    public Marker marker() {
        return this.marker;
    }

    public float[] alleleFreq() {
        return (float[])this.alleleFreq.clone();
    }

    public float allelicR2() {
        float f = 1.0f / (float)this.nSamples;
        float f2 = this.sumCallExpected - this.sumCall * this.sumExpected * f;
        float f3 = this.sumSquareCall - this.sumCall * this.sumCall * f;
        float f4 = this.sumExpectedSquare - this.sumExpected * this.sumExpected * f;
        float f5 = f3 * f4;
        return f5 == 0.0f ? 0.0f : Math.abs(f2 * f2 / f5);
    }

    public float doseR2() {
        float f = 1.0f / (float)this.nSamples;
        float f2 = this.sumSquareExpected - this.sumExpected * this.sumExpected * f;
        float f3 = this.sumExpectedSquare - this.sumExpected * this.sumExpected * f;
        return f3 == 0.0f ? 0.0f : Math.abs(f2 / f3);
    }

    public float hweDoseR2() {
        float f = 1.0f / (float)this.nSamples;
        float f2 = (this.sumSquareExpected - this.sumExpected * this.sumExpected * f) / (float)this.nSamples;
        float f3 = this.sumExpected / (2.0f * (float)this.nSamples);
        float f4 = 2.0f * f3 * (1.0f - f3);
        return f4 == 0.0f ? 0.0f : Math.abs(f2 / f4);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(this.marker);
        stringBuilder.append('\t');
        for (int i = 0; i < this.alleleFreq.length; ++i) {
            stringBuilder.append(i == 0 ? "AF=" : Character.valueOf(','));
            stringBuilder.append(this.alleleFreq[i]);
        }
        stringBuilder.append('\t');
        stringBuilder.append("AR2=");
        stringBuilder.append(GprobsStatistics.format(this.allelicR2()));
        stringBuilder.append('\t');
        stringBuilder.append("DR2=");
        stringBuilder.append(GprobsStatistics.format(this.doseR2()));
        stringBuilder.append('\t');
        stringBuilder.append("HDR2=");
        stringBuilder.append(GprobsStatistics.format(this.hweDoseR2()));
        return stringBuilder.toString();
    }

    private static String format(float f) {
        if (Double.isNaN(f)) {
            return "NaN";
        }
        if ((double)f == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if ((double)f == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        return df.format(f);
    }
}

