% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{evalf}
\alias{evalf}
\title{Evaluating a SymEngine Object}
\usage{
evalf(expr, bits = 53L, complex = FALSE)
}
\arguments{
\item{expr}{A SymEngine object.}

\item{bits}{The precision.}

\item{complex}{Whether or not to be evaluated as a complex number.}
}
\value{
Same type as \code{expr} argument.
}
\description{
This function will evaluate a SymEngine object to its "numerical" form
with given precision. User may further use \code{as.double()} to convert
to R value.
}
\examples{
expr <- Constant("pi")
evalf(expr)
as.double(evalf(expr)) == pi
}
